import java.util.Iterator;

public interface Tree<E> {

	public int size();

	public boolean isEmpty();
	
	public Iterator<E> iterator();
	
	public Iterable<Node<E>> nodes();
	
	public E replace(Node<E> v, E e);
	
	public Node<E> root();
	
	public Node<E> parent(Node<E> v);
	
	public Iterable<Node<E>> children(Node<E> v);
	
	public boolean isInternal(Node<E> v);
	
	public boolean isExternal(Node<E> v);
	
	public boolean isRoot(Node<E> v);
}
