import java.util.LinkedList;

public class BNode<E> implements Node<E>{

	private E elem;
	private BNode<E> parent;
	private BNode<E> left;
	private BNode<E> right;
	
	public BNode(E e, BNode<E> p){
		elem = e;
		parent = p;
	}
	
	public E getElement(){
		return elem;
	}
	
	public void setElement(E e){
		elem = e;
	}
	
	public BNode<E> getParent(){
		return parent;
	}
	
	public void setParent(Node<E> p){
		parent = (BNode<E>) p;
	}
	
	public BNode<E> getLeft(){
		return left;
	}
	
	public void setLeft(BNode<E> l){
		left = l;
	}
	public BNode<E> getRight(){
		return right;
	}
	
	public void setRight(BNode<E> r){
		right = r;
	}
	
	public LinkedList<Node<E>> getChildren(){
		LinkedList<Node<E>> l = new LinkedList<Node<E>>();
		if (left != null)
			l.add(left);
		if (right != null)
			l.add(right);
		return l;
	}
}
