// some globals
var REDRAW_STATS=0x00000001;
var REDRAW_LAYOUT=0x00000002;
var REDRAW_ELEMENTS=0x00000004;
var REDRAW_ALL=REDRAW_STATS | REDRAW_LAYOUT | REDRAW_ELEMENTS;
// ID of the element where bin items are drawn
var ID_LAYOUT_RESIZABLE="#ist_layout_resizable";
var ID_BEST_FIT = 5; // dropdown option that cycles through most popular packer methods
var MEDIA_TYPE_BIN = 0;
var MEDIA_TYPE_ROLL = 1;
var CUT_COMPLEXITY_MIN = 1;
var CUT_COMPLEXITY_MAX = 5 ;
var TILE_NAV_IMAGE_WIDTH = 50; /* width of prev/next images in tile details */


UILayout = function(maxLayoutWidth,defLayoutHeight,defRollWidth) 
{
  this.ctor(maxLayoutWidth,defLayoutHeight,defRollWidth);
};

UILayout.prototype = {
  // our pseudo constructor
  ctor: function(maxLayoutWidth,defLayoutHeight,defRollWidth)
  {
    this.layoutWindow = null;
	this.rollWidth = defRollWidth;
    this.maxLayoutWidth = maxLayoutWidth;
    this.defLayoutHeight = defLayoutHeight;
    this.pxRatio = 1;
    this.layoutWindow  = null;	
    this.xCursor = 0;
    this.yCursor = 0;
    this.zCursor = 10;
    this.stdoffset = 15;
    this.printJob = new PrintJob(this);   
    this.width = maxLayoutWidth;
    this.height = defLayoutHeight;
    this.binHeightPx = this.height; // height in px that is passed to the packer
    this.binLengthIn = 48;		// default
    this.binWidthPx= this.width;
    this.marginIn = 0;
	this.marginPx = 0;
	this.gutterPx=0;
	this.mediaType = MEDIA_TYPE_BIN;
	this.binTabManager = new BinTabManager(this);
	this.packMethod = RectContactPointRule; // default to best contact	
	this.calcTiles = false; // print element represents one tile and we need to return total number of tiles that fit on this rolls
	this.cutComplexity = 1;// 
	this.ratioMultipliler = 3; // used to maintain aspect ratio of the dimensions of the details tile. 
							// this value may come from some code that will determine the display type ( retina vs regular)
	
  },
  // init routine for the layout window
  Initialize:function(jsonString)
  {
	  
	  this.layoutWindow = $(ID_LAYOUT_RESIZABLE);
	  this.layoutWindow.height(this.displayHeight());
	  this.layoutWindow.resizable();
	  
	  // keep functions at top
	  this.layoutWindow.bind( "resizestart", function() {
			var a = $(this);
			// not used? var windowfloor = (a.offset().top + a.height());
			var childbottom = 0;
			a.children(".ist_instanceCutMargin").each(function(i) {
				var b = ($(this).offset().top + $(this).height());
				if(b > childbottom) {
					childbottom = b;
				}
			});
			a.resizable("option" , "minHeight" , (childbottom - a.offset().top));
		});
	  
	  this.layoutWindow.bind( "resizestop", function() 
	  {
			g_UILayout.updateHeight($(this).height());
			g_UILayout.Redraw(REDRAW_STATS);
	  });
	  
	  
	  this.binTabManager.Initialize(); // set up bin tabs
	  this.ResetPxRatio();
	  this.updateHeight();
	  this.UpdatePackMethod();
	
	  if(typeof jsonString!='undefined' && jsonString!= "")
	  {
		  this.PopulateUIFromJson(jsonString);
		  // if bin packing occurs everything will be redrawn.
		  // if json ddid not supply any items at least redraw stats which will update
		  // static fields,e.g margin and gutter
		  this.Redraw(REDRAW_STATS);
		  this.ResetPxRatio();
	  }	  
	  if(this.printJob.elements.length > 0)
      {
		  this.BinPack();		
      }
	  else
	  {
		  // no json or json did not have any elements - add a default one
		  this.AddElement();
		  this.Redraw(REDRAW_ALL);
	  }
	  // update some labels in the stats page
	 this.UpdateUIForTiles();	
	 this.InitCutSlider();
	 
  },
  //----------------
  displayWidth:function displayWidth() 
  {
		return ( this.width - 2);
  },
  //--------------
  displayHeight:function () 
  {
		return ( this.height - 2);
  },
  //---------------
  updateHeight:function (h) 
  {
	  if(typeof h != 'undefined' && !isNaN(h))
	  {
		  this.height = (h + 2);
	  }
	 
  },
  //-----------------------------------
  ResetPxRatio: function () 
  {
	  	var elem = $(".ist_stockwidth input");
		if(!isNaN(elem.val())) {
			this.rollWidth = elem.val();
		}
		var origPxRatio = this.pxRatio;

		// Determine the best width in pixels, to represent the new width in 
		// inches. We prefer a number of pixels divisable by the number of,
		// inches, so that we can work in whole pixels with our math.
		var ratioMod = (this.maxLayoutWidth % this.rollWidth);
		this.width = (this.maxLayoutWidth - ratioMod);
		this.binWidthPx = this.width;
		// this.height = (this.height - (this.height % ratioMod));
		this.pxRatio = (this.width / this.rollWidth);
		
		//var layoutArea = this.binHeightPx* this.binWidthPx;

		
		// Need to reset the width, height, top, and left of each element-instance
		// reset to 0,0
		for(var i in this.printJob.elements) 
		{
			//	reset width and height
			
			var origWidth = this.printJob.elements[i].width;
			var origHeight = this.printJob.elements[i].height;
			var curElement = this.printJob.elements[i];
			
			if(origWidth >  0 &&  origHeight > 0 )
			{
							
				//var scaleFactor = Math.min( this.binWidthPx/origWidth, this.binHeightPx/origHeight);
				//var curElArea = curElement.width * curElement.height;
				//var scaleFactor =  Math.sqrt(curElArea/layoutArea);
			
				curElement.width = ((origWidth / origPxRatio) * this.pxRatio);
				curElement.height = ((origHeight / origPxRatio) * this.pxRatio);
				
				for(var x in this.printJob.elements[i].instances) 
				{
					var curInstance = curElement.instances[x];					
					// constrain display dimensions so we never grow past the edges of the display window
					curInstance.UpdateDisplayDimensions(Math.min(origWidth,curElement.width),
														Math.min(origHeight,curElement.height));				
					var origTop = curInstance.top;
					var origLeft = curInstance.left;
					curInstance.updatePosition(((parseInt(origLeft) / origPxRatio) * this.pxRatio) /*+ "px"*/,((parseInt(origTop) / origPxRatio) * this.pxRatio) /*+ "px"*/);							
				}
			}
		}

		elem = (this.calcTiles ? $(".ist_bleed input") : $(".ist_cutmargin select"));
		if(!isNaN(elem.val())) {
			// Add a 1/32-inch margin of error to the gutter, 
			// and convert the inch-value to pixels
			// this messes up bin packing of items that have no  gutter and margin
			this.gutterIn = elem.val();
			this.gutterPx = (((Number(this.gutterIn) /*+ 0.03125*/) * this.pxRatio) / 2);
			// alert(cutElem.val() + "/" + (Number(cutElem.val()) + 0.03125) + "/" + pxRatio + "/" + ((Number(cutElem.val()) + 0.03125) * pxRatio) + "/" + (((Number(cutElem.val()) + 0.03125) * pxRatio) / 2) + "/" + gutterPx);
		}
		// for tiles we use bleed
		
		
		// and the stock margin
		elem = $(".ist_stockmargin input");
		if(!isNaN(elem.val())) {
			// Add a 1/32-inch margin of error to the margin, 
			// and convert the inch-value to pixels
			// this messes up bin packing of items that have no  gutter and margin
			this.marginIn = elem.val();
			this.marginPx = (((Number(this.marginIn) /*+ 0.03125*/) * this.pxRatio) / 2);
		}	
		// finally update the length of the plate in pixels 
		// this is used by the packer
		elem = $(".ist_platelength input");
		if(!isNaN(elem.val())) 
		{			 
			this.UpdateBinHeightPx(elem.val());
		}				
	},
	UpdateBinHeightPx:function (inchesLength)
	{
		//set the board length in pixels based on the current pxRatio.
		// This variable used by the packer 
		this.binLengthIn = inchesLength;
		this.binHeightPx = (((Number(inchesLength)) * this.pxRatio));		
	},
	//-------------------------------
	DrawElementsSection:function () 
	{
		$("div.elements table tbody").children().remove();
		for(var i in this.printJob.elements) {
			this.printJob.elements[i].drawElementControl((Number(i) + 1), this.printJob.elements.length);
		}
		$(".addelement").bind("click", function() {
			//AddElementToPlate(myPlate,true); // refreshes		
			g_UILayout.AddElement();			
		});
		
		$(".ist_deleteelement").bind("click", function() {
			g_UILayout.RemoveElement($(this).parent().parent().index());
							
		});
		$(".ist_ename").bind("change", function() {
			var elem = $(this).find("input");
						
			g_UILayout.UpdateElementName(elem.parent().parent().index(),elem.val());
		});
		$(".ist_ewidth").bind("change", function() {
			var elem = $(this).find("input");	
			
			g_UILayout.UpdateElementWidth(elem.parent().parent().index(),ValidateNumber(elem));			
		});
		$(".ist_eheight").bind("change", function() {
			var elem = $(this).find("input");
			
			g_UILayout.UpdateElementHeight(elem.parent().parent().index(),ValidateNumber(elem));
		});
		$(".ist_ecount").bind("change", function() {
			var inputElem = $(this).find("input");
			var i = inputElem.parent().parent().index();	
			g_UILayout.AdjustInstanceCount(inputElem,i);								
		});
		DisEnableElement("#ist_efit-btn" ,this.printJob.TotalInstanceCount());
	},
	//-------------------------------
	DrawLayoutSection:function () 
	{
				
		this.layoutWindow.width(this.displayWidth());
		this.layoutWindow.height(this.displayHeight());
		this.layoutWindow.resizable("option" , "maxWidth" , this.displayWidth() );
		this.layoutWindow.resizable("option" , "minWidth" , this.displayWidth() );
		//this.layoutWindow.resizable("option" , "maxHeight" , this.displayHeight() );
		//this.layoutWindow.resizable("option" , "minHeight" , this.displayHeight() );
		// remove all children to clear drawing surface
		this.layoutWindow.children(".ist_instanceCutMargin").remove();
		this.layoutWindow.children(".ist_binrect").remove();
		// remove tile div 		
		this.layoutWindow.children("#ist_tile_div").remove();
		
		this.printJob.DrawBins();
		var elem = $(".ist_instanceCutMargin");
		elem.draggable( { snap: true, snapTolerance: 8, containment: 'parent', drag: function() {
			var a = $(this);
			// Expand the window downward to accomodate the objects new position.
			// if((a.position().top + a.height()) > (resizablediv.height() - 10)) {
			// 	resizablediv.height(a.position().top + a.height() + 10);
			// }
		} } );
		// elem.css("position","absolute");
		elem.bind( "dragstop", function() {
			var elem = $(this);
			// Need to shift element to overcome 2px-offset imposed by the snap functionality.

			var newTop = (parseInt(elem.css("top")) - 2);
			if(newTop < 0) {
				newTop = 0;
				elem.css("top",newTop);
			}
			if((newTop + elem.outerHeight()) > g_UILayout.layoutWindow.height()) {
				newTop = (g_UILayout.layoutWindow.height() - elem.height());
				elem.css("top",(newTop + "px"));
			}


			var newleft = (parseInt(elem.css("left")) - 2);
			if(newleft < 0) {
				newleft = 0;
				elem.css("left",newleft);
			}
			if((newleft + elem.outerWidth()) > g_UILayout.layoutWindow.width()) {
				newleft = (g_UILayout.layoutWindow.width() - elem.width());
				elem.css("left",(newleft + "px"));
			}

			// elem.css("left",(parseInt(elem.css("left")) - 1));
			// Need to report back to obj the new top and left
			g_UILayout.UpdateInstPosition(elem.data("elemIndex"), elem.data("instIndex"), elem.css("left"), elem.css("top"));
		});
		$(".ist_rotateswitch").bind("click", function() {
			var elem = $(this).parentsUntil(".ist_instanceCutMargin").parent();
			g_UILayout.RotateInstance(elem.data("elemIndex"), elem.data("instIndex"));
			
		});
		$(".ist_cloneswitch").bind("click", function() {
			var elem = $(this).parentsUntil(".ist_instanceCutMargin").parent();
			elem.css("background-color","red");
			//myPlate.cloneInst(elem.data("elemIndex"), elem.data("instIndex"));
			g_UILayout.CloneInstance(elem.data("elemIndex"),elem.data("instIndex"));
		});
		$(".ist_deleteswitch").bind("click", function() {
			var elem = $(this).parentsUntil(".ist_instanceCutMargin").parent();
			g_UILayout.RemoveInstance(elem.data("elemIndex"),elem.data("instIndex"));
							
		});
		// flipping through the tiles
		$(".ist_tilenext_image").bind("click", function() {
			g_UILayout.HandlePreviewTileClick(true);
		});
		
		$(".ist_tileprev_image").bind("click", function() {
			g_UILayout.HandlePreviewTileClick(false);							
		});
		
		/*
		$("#ist_tile_div").on("load",function() {
			var canvas = $("#ist_canvas");
			if(canvas!=null && typeof canvas !='undefined')
			{
				g_UILayout.OnTileDetailsImageLoad();
			}
		});*/
			
		// draw descriptive info on tabs
		this.binTabManager.RefreshTabInfo();
	},
	//----------------------------------
	// TODO: make accessor in printJob, validate input
	UpdateInstPosition:function (elemIndex,instIndex,left,top) 
	{
		this.printJob.elements[elemIndex].UpdatePosition(instIndex,left,top); //instances[instIndex].updatePosition(left,top);
	},
	RotateInstance: function (elemIndex,instIndex) 
	{
		var element = this.printJob.elements[elemIndex];
		var instance = element.instances[instIndex];
		instance.toggleOrientation(); // not used any more
		// Prevent rotation from moving the right side of the instance, 
		// beyond the right side of the layout window.
		var curH = instance.height;
		var curW = instance.width;
		instance.height = curW;
		instance.width = curH;
		
		if(instance.w > instance.h) {
			if((parseInt(instance.left) + parseInt(instance.h)) > this.layoutWindow.width()) {
				instance.left = (this.layoutWindow.width() - parseInt(instance.h) + 2) + "px";
			}
		}
		else {
			if((parseInt(instance.left) + parseInt(instance.w)) > this.layoutWindow.width()) {
				instance.left = (this.layoutWindow.width() - parseInt(instance.w) + 2) + "px";
			}
		}
		// Prevent rotation from moving the bottom of the instance,
		// beyond the bottom of the layout window.
		// Revisit: maybe not needed at all
		if(instance.w > instance.h) {
			if((parseInt(instance.top) + parseInt(instance.w)) > this.layoutWindow.height()) {
				this.layoutWindow.height(parseInt(instance.top) + parseInt(instance.w));
				this.height = this.layoutWindow.height();
			}
		}
		else {
			if((parseInt(instance.top) + parseInt(instance.h)) > this.layoutWindow.height()) {
				this.layoutWindow.height(parseInt(instance.top) + parseInt(instance.h));
				this.height = this.layoutWindow.height();
			}
		}
		this.Redraw(REDRAW_LAYOUT);
	}	
	,
	//----------------------------------
	DrawStatisticsSection:function()  
	{
		// Calculate the minimum number of plates needed to print the 
		// desired number of each element
		var plateMultiple = 0;
		for(var i in this.printJob.elements) {
			// (desiredCount/instancesPerPlate)
			var printCount = Math.ceil(this.printJob.elements[i].desiredCount / this.printJob.elements[i].instances.length);
			if(printCount > plateMultiple) {
				plateMultiple = printCount;
			}
		}

		$(".stat").children("dl").remove();
		var plateUsed = 0;
		var listItem = "";
		for(var i in this.printJob.elements) 
		{

			listItem += "<dt>" + this.printJob.elements[i].name + "<\/dt>";
			if(this.printJob.elements[i].width > 0 && this.printJob.elements[i].height > 0) 
			{
				var finalCount = (this.calcTiles ? this.printJob.elements[i].desiredCount : this.printJob.elements[i].instances.length);
				listItem += "<dd>" + (finalCount * plateMultiple) + "<\/dd>";			
			}
			else 
			{
				listItem += "<dd>0<\/dd>";
			}

			plateUsed += (((this.printJob.elements[i].width / this.pxRatio) * 
						 (this.printJob.elements[i].height / this.pxRatio)) * 
						 this.printJob.elements[i].instances.length);
		
			// alert("(" + (this.elements[i].width / pxRatio) + " * " + this.elements[i].height + ") * " + this.elements[i].instances.length);
		}
		if(listItem.length > 0) 
		{
			$(".elementlist").after("<dl>" + listItem + "<\/dl>");
		}
		
		var cutMarginHTML = (this.calcTiles ? $(".ist_bleed input") : $(".ist_cutmargin select"));
		// this trick prevents the handler from being called multiple times
		cutMarginHTML.unbind("change").bind("change", function() {
			
			if((this.gutterIn) != $(this).val()) {
				// this is gutter specified in the print job.
				g_UILayout.ResetPxRatio();
				g_UILayout.BinPack();
			}
		});
		
		var stockMarginHTML = $(".ist_stockmargin input");
		
		// this trick prevents the handler from being called multiple times
		stockMarginHTML.unbind("change").bind("change", function() {
			if((g_UILayout.printJob.marginIn) != $(this).val()) 
			{
				// this is the margin specified in print job
				g_UILayout.ResetPxRatio();	
				g_UILayout.BinPack();
			}
		});
		
		var packMethodsHtml = $(".ist_pack_methods select");
		// this trick prevents the handler from being called multiple times
		packMethodsHtml.unbind("change").bind("change", function() 
		{
			var val = $(this).val();
			if( !isNaN(val) && (this.packMethod) != val) 
			{				
				g_UILayout.UpdatePackMethod();
				g_UILayout.BinPack();								
			}
		});
						
		//-----------------------------
		var stockWidthHTML = $(".ist_stockwidth input");
		// this trick prevents the handler from being called multiple times
		stockWidthHTML.unbind("change").bind("change",function(){
	
			if((g_UILayout.width / g_UILayout.pxRatio) != $(this).val()) {
				g_UILayout.ResetPxRatio();	
				g_UILayout.BinPack();	
			}
		});
		
		//-----------------------------
		var plateLengthHTML = $(".ist_platelength input");
		// this trick prevents the handler from being called multiple times
		plateLengthHTML.unbind("change").bind("change",function(){
	
			var lengthIn = $(this).val();
			if(!isNaN(lengthIn))
			{
				// this is what will be passed to the packer as a height parameter. does not affect the visual layout
				g_UILayout.UpdateBinHeightPx(lengthIn);	
				g_UILayout.BinPack();	
			}								
		});

		// update UI fields if they are different
		if(stockMarginHTML.val() != this.marginIn) {
			stockMarginHTML.val(this.marginIn);
		}
		if(cutMarginHTML.val() != this.gutterIn) {
			cutMarginHTML.val(this.gutterIn);
		}
		if(stockWidthHTML.val() != this.rollWidth) {
			stockWidthHTML.val(this.rollWidth);
		}
		if(plateLengthHTML.val() != this.binLengthIn) {
			plateLengthHTML.val(this.binLengthIn);
		}
		
		
		/*var plateLengthHTML = $(".ist_platelength");
		plateLengthHTML.html(this.height / pxRatio); // (layoutWindow.height() + 2)
		plateLengthHTML.format({format:"#,###.##"});
		plateLengthHTML.append("-inches");*/

		var stockLengthHTML = $(".ist_stocklength");
		stockLengthHTML.html(plateMultiple);
		

		var stockLength = (this.height * plateMultiple); // (layoutWindow.height() + 2)
		var stockUsedHTML = $(".ist_stockused");
		var stockUsed = ((stockLength / this.pxRatio) * this.rollWidth);
		
		stockUsedHTML.html(stockUsed);
		stockUsedHTML.format({format:"#,###.##"});
		stockUsedHTML.append("-square inches");

		var stockWasteHTML = $(".ist_stockwaste");
		var stockWaste = (stockUsed - (plateUsed * plateMultiple));
		stockWasteHTML.html(stockWaste);
		stockWasteHTML.format({format:"#,###.##"});
		stockWasteHTML.append("-square inches");
		
		// display number of bins if media type is bin
		this.UpdateBinsOrTilesCount();
		this.DisplayLinearAndSqFt();
		this.DisplayCumulativePerimeter();
	
		this.printJob.UpdateServerData();

	},
	// redraws various sections of the layout
	Redraw:function(redrawFlags)
	{
		if(redrawFlags & REDRAW_ELEMENTS)
		{
			this.DrawElementsSection();
		}
		if(redrawFlags &  REDRAW_STATS)
		{
			this.DrawStatisticsSection();
		}
		if(redrawFlags &  REDRAW_LAYOUT)
		{
			this.DrawLayoutSection();
		}		
	},
	//---------------------------------
	AddElement :function()
	{
		this.printJob.AddElement(); // does what AddElementToPlate used to
		this.Redraw(REDRAW_ELEMENTS);
	},
	//-------------------
	RemoveElement:function(elem)
	{
		this.printJob.RemoveElement($(this).parent().parent().index());
		this.Redraw(REDRAW_ALL);
	},
	//---------------------------------
	UpdateElementName:function(elIndex, val)
	{
		/*var i = elem.parent().parent().index();
		myPlate.elements[i].name = elem.val();
		Refresh(myPlate);	*/
		// TODO: add an accessor to printJob, don't access directly
		this.printJob.elements[elIndex].name = val;
		this.Redraw(REDRAW_LAYOUT|REDRAW_STATS);
	},
	// TODO: make accessor in printJob
	UpdateElementWidth:function(index,val)
	{
		this.printJob.elements[index].setWidth(val);
		// only redraw when num isnstances > 0
		if(this.printJob.elements[index].instances.length > 0)
		{
			this.Redraw(REDRAW_LAYOUT);
		}		
	},
	
	UpdateElementHeight:function(index,val)
	{
		this.printJob.elements[index].setHeight(val);
		// only redraw when num isnstances > 0
		if(this.printJob.elements[index].instances.length > 0)
		{
			this.Redraw(REDRAW_LAYOUT);
		}
	},
	//-----------------------------
	AdjustInstanceCount:function(inputElem, i)
	{
		this.printJob.AdjustInstanceCount(inputElem, i);		
		this.BinPack();	
	},
	//----------------
	RemoveInstance:function(elementIndex, instanceIndex)
	{
		this.printJob.RemoveInstance(elementIndex,instanceIndex);
		this.BinPack();
		
	},
	//-------------
	CloneInstance:function(elementIndex,instanceIndex)
	{
		this.printJob.CloneInstance(elementIndex,instanceIndex);
		this.BinPack();
	},
	HandlePreviewTileClick:function(elementIndex,isNext)
	{
		this.printJob.HandlePreviewTileClick(elementIndex,isNext);
		this.Redraw(REDRAW_LAYOUT);
	},
	//------------------
	BinPack:function()
	{
		// don't bother if there are no elements
		if(this.printJob.elements.length > 0)
		{
			this.binTabManager.ResetTabs();
			this.printJob.NestItems();
			// add tabs to match the number of bins
			if(this.printJob.bins.length > 1)
			{
				this.binTabManager.AddTabs(this.printJob.bins.length-1);
			}
			this.Redraw(REDRAW_ALL);
		}		
	},
	//--------------------
	GrowLayoutWindow:function(elemDisplayHeight)
	{
		if((this.xCursor + elemDisplayHeight) > parseInt(this.layoutWindow.height())) 
		{
			this.layoutWindow.height(this.xCursor + elemDisplayHeight);
			this.height = this.layoutWindow.height();
		}
	},
	//----------------------------
	UpdateCursors:function()
	{
		this.xCursor += this.stdoffset;
		this.yCursor += this.stdoffset;
		this.zCursor += 10;
	},
	//-------------------------
	UpdatePackMethod:function()
	{
		var packMethodEl=$("#ist_pack_methods_desc");
		var dropDown = $(".ist_pack_methods select");		
		var selIndex = parseInt(dropDown.val());
		// update pack method and description
		this.packMethod = selIndex;
		
		switch(this.packMethod)
		{
			case RectBestShortSideFit:
				packMethodEl.text("Positions the item against the short side of a free rectangle into which it fits the best.");
				break;
			case RectBestLongSideFit: 
				packMethodEl.text("Positions the item against the long side of a free rectangle into which it fits the best.");
				break;
			 case RectBestAreaFit:
			 	packMethodEl.text("Positions the item into the smallest free rectangle into which it fits");
			 	break;
			 case RectBottomLeftRule: 
				 packMethodEl.text(" Does the Tetris placement");
				 break;
			 case RectContactPointRule:
			 	packMethodEl.text("Chooses the placement where the item touches other rectangles as much as possible");
			 	break;
			 case ID_BEST_FIT:
				 packMethodEl.text("Tries all pack methods to produce the best fit");
				 break;
		}
	},
	DisplayPackError:function(err)
	{
		var packStatus =$("#ist_packstatus");				
		packStatus.append("<br>" + err );
		packStatus.show();
		this.Redraw(REDRAW_LAYOUT);
	},
	// resets the window to default size and clears pack status
	ResetPackStatus:function()
	{		
		// resize the window to default
		this.updateHeight(this.defLayoutHeight);		
		var packStatus = $("#ist_packstatus");
		packStatus.text("");
		packStatus.hide();
		
	},
	/* determine if the print element fits on the bin either the way it is or rotated
	 * take into account the margin and gutter.
	 * This code was taken from 
	 * http://stackoverflow.com/questions/13784274/detect-if-one-rect-can-be-put-into-another-rect
	 * It does not work quite right - for example returns false if the width is 33 and height is 96 and the plate 96x48
	 * TODO: Revisit, for now always return true and rely on the code in NestItems to detect that the item does not fit
	 * 
	 */
		
	
	ElementFits:function(item)
	{
		return true;
		/*
		var elWidth = item.width;
		var elHeight = item.height;
		// account for gutter
		elHeight+= (elHeight + this.gutterPx < this.binHeightPx ? this.gutterPx : 0);
		elWidth+= (elWidth + this.gutterPx < this.binWidthPx ? this.gutterPx : 0);
		
		// account for  margin 
		var binHeight = this.binHeightPx - this.marginPx;
		var binWidth = this.binWidthPx - this.marginPx;
		
		var p = elWidth;
		var q = elHeight;
		var a = binWidth;
		var b = binHeight;
		
		return(p <= a && q <= b) || 			  
		(p >= a &&
                b >= ((2*p*q*a) + ((p*p) - (q*q)) * Math.sqrt((p*p) + (q*q) -(a*a))) / ((p*p) + (q*q)));	*/
	},
	/* populate UI from JSON data
	 * Return true if populated successfully - we need to redraw and reset px ratio
	 * in case some values changed
	 * 
	 */
	PopulateUIFromJson:function(jsonString)
	{
		var ret = true;
		try
		{
			var jsonObj = jQuery.parseJSON( jsonString );	
			if(jsonObj!=null)
			{
				var params=jsonObj[0];
				this.printJob.bomId = params.bom_id;
				this.printJob.jobId = params.job_id;
				this.marginIn = params.margin;
				this.gutterIn = params.gutter;
				// width and length of the material
				
				this.rollWidth = params.width;
				this.binLengthIn= params.length;
				this.mediaType = params.type;// 1 = roll or board =0
				if(typeof params.calc_tiles !='undefined')
				{
					this.calcTiles = params.calc_tiles;
				}
				/*// create one print element whose width is the width of the media - margin
				// and height is the tile height. We will need to figure out how many layout instances to create to fill the 
				// media 
				var newPrintElem = this.printJob.AddElement(params.filename);
				newPrintElem.setWidth(this.rollWidth);
				newPrintElem.setHeight(params.tile_height);					
				newPrintElem.SetupPreviewFileName();
				newPrintElem.addLayoutInstance("auto");*/	
				
				// now parse all print elements				
				try
				{
					var newPrintElem;
					for(var i =0; i < params.print_els.length;++i)
					{
						var jsonElem = params.print_els[i];
						
						newPrintElem = this.printJob.AddElement(jsonElem.filename);
						newPrintElem.InitFromJson(jsonElem);		
					}
					// adjust th
										
				}
				catch(z)
				{
					
				}
								
			}
		}
		catch(e)
		{
			this.DisplayPackError("Malformed JSON object");
			ret = false;
		}	
		return ret;
	},
	UpdateBinsOrTilesCount:function()
	{
		var strLabel = "Number of ";
		var strNum = "";
		if(this.calcTiles)
		{
			strLabel+="Tiles";
			strNum = this.printJob.GetNumTiles();
		}
		else
		{
			strLabel += (this.mediaType == MEDIA_TYPE_BIN ? "Boards" :"Rolls");
			strNum = "&nbsp;" + this.printJob.GetTotalNumBins();			
		}
				
		$("#ist_bins_tiles_label").html(strLabel);
		$("#ist_numbins_or_tiles").html( strNum);				
	},
	// tis is only used for tiles
	/* Source:
	 * Linear ft... 
	 * when we are printing rolls the height of the tiles times the number of tiles will determine how many linear feet 
	 * of ROLL material are needed to produce all the tiles. 1
	 * 50 ft long rolls could only fit (15) 10 ft tiles. So if we were to do a 300 ft wall we would need 2 rolls.
	 * 
	 */
	DisplayLinearAndSqFt:function()
	{
		
		if(this.calcTiles)
		{
			
			var linearFt= this.printJob.GetStats(STAT_LINEAR_FEET).toFixed(2);
			var sqFt = this.printJob.GetStats(STAT_SQUARE_FEET).toFixed(2);
			
			$("#ist_linear_ft").html(linearFt);
			//$("#ist_linear_ft").format({format:"#,###.##"});
			$("#ist_linear_ft").append("'");
			
			$("#ist_sq_ft").html(sqFt);
			//$("#ist_sq_ft").format({format:"#,###.##"});
			$("#ist_sq_ft").append("'");
			
			/* $("#ist_linear_ft_label").show();
			 $("#ist_linear_ft").show();
			 $("#ist_sq_ft_label").show();
			 $("#ist_sq_ft").show();*/
		}	
	},
	// Updates a static field by id
	UpdateStaticField:function(fieldId, string, redrawFlags)
	{
		$(fieldId).html(string);
		// someties redrawing is not needed
		if(redrawFlags >=0)
		{
			this.Redraw(redrawFlags);
		}
		
	},
	// necessary things for tiles
	UpdateUIForTiles:function()
	{
		if(this.calcTiles)
		{
			this.UpdateStaticField("#ist_gutter_label","Bleed",REDRAW_STATS);
			$("#ist_linear_ft_label").show();
			$("#ist_linear_ft").show();
			$("#ist_sq_ft_label").show();
			$("#ist_sq_ft").show();
			$(".ist_bleed").show();
			$(".ist_cutmargin").hide();
		}
		else
		{
			 $("#ist_linear_ft_label").hide();
			 $("#ist_linear_ft").hide();
			 $("#ist_sq_ft_label").hide();
			 $("#ist_sq_ft").hide();
			 $(".ist_bleed").hide();
			 $(".ist_cutmargin").show();
			 
		}		
	},
	DisplayCumulativePerimeter:function()
	{
		var perimeter =  this.GetCumulativePerimeterFt();
		this.UpdateStaticField("#ist_perimeter",perimeter.toFixed(2) + "'",-1); // don't redraw
		
	},
	GetCumulativePerimeterFt:function()
	{
		return (this.printJob.GetCumulativePerimeterIn() * this.cutComplexity) /12;
	},
	// initialze the cut complexity slider
	InitCutSlider:function()
	{
		$('#ist_cut_complexity_slider').slider();
		//set the options
		$('#ist_cut_complexity_slider').slider( "option", "min", CUT_COMPLEXITY_MIN );
		$('#ist_cut_complexity_slider').slider( "option", "max", CUT_COMPLEXITY_MAX );
		//$('#ist_cut_complexity_slider').on( "slidestart", this.OnSlideChange );
		//$('#ist_cut_complexity_slider').on( "slidestop", this.OnSlideChange );
		
		//$('#ist_cut_complexity_slider').on( "slide", this.OnSlideChange );
		$('#ist_cut_complexity_slider').on( "slidechange", this.OnSlideChange );
		
		$( '#ist_cut_complexity_slider' ).slider( "option", "step", 1 );

	},
	OnSlideChange:function(event,ui)
	{
		var val = $( "#ist_cut_complexity_slider" ).slider( "option", "value" );
		if(val > 0 && val != g_UILayout.cutComplexity)
		{
			g_UILayout.cutComplexity = val;
			g_UILayout.UpdateStaticField("#ist_cut_complexity",g_UILayout.cutComplexity,REDRAW_STATS);
			g_UILayout.DisplayCumulativePerimeter();
		}
		
	},
	/*
	OnTileDetailsImageLoad:function()
	{
		this.printJob.HandleTileDetailsImageLoad();
	},*/
	// accessors to hidden x pos value used to draw a tile detail
	GetTileXPos:function()
	{
		return parseFloat($("#ist_tile_xpos").val());
	},
	SetTileXPos:function(value)
	{
		$("#ist_tile_xpos").val(value);
	},
	// accessors to hidden image width value used to draw a tile detail
	GetTileImageWidth:function()
	{
		return parseFloat($("#ist_tileimage_width").val());
	},
	SetTileImageWidth:function(value)
	{
		$("#ist_tileimage_width").val();
	}
	
	
};