// this class represents a print job
var STAT_LINEAR_FEET = 0;
var STAT_SQUARE_FEET = 1;

PrintJob = function(uiLayout) 
{
  this.ctor(uiLayout);
};

PrintJob.prototype = {

  ctor: function(uiLayout) 
  {
   this.uiLayout = uiLayout;
   this.elements = new Array();
   this.bins = new Array(); // at least one bin, possibly more
   this.nextBinId = 0;
   this.bomId = "0";
   this.jobId = "0";
   // create the first bin
   this.bins.push(new Bin(this.uiLayout,this.nextBinId++));	
   
   
  },
  // ony draw the items that belong in that bin, based on the selected tab index
   DrawBins:function()
  {
		/*if(this.bins.length == 0)
		{
			this.bins.push(new Bin(this.uiLayout,this.nextBinId++));	
		}*/
		//always just draw 1 bin rect
		this.bins[0].Draw(ID_LAYOUT_RESIZABLE);
		
		// now figure out which tab index it is, i.e which bin index it is
		var tabIndex = this.uiLayout.binTabManager.selectedTabIdx;
		if(!IsValidIndex(tabIndex,this.bins))
		{
			tabIndex = 0;
		}
		// first draw bin rectangles
		for(var i in this.elements) 
		{
			
			this.elements[i].drawLayoutControls(i,tabIndex);
		}
	},
	//---------------
	NestItems:function()
	{
		
		if(this.uiLayout.calcTiles)
		{
			this.NestForTiles();
		}
		else
		{
			if(this.uiLayout.packMethod == ID_BEST_FIT)
			{
				this.PackBestFit();
			}
			else
			{
				this.DoNestItems(this.uiLayout.packMethod);
			}
		}
		
	},
	//-----------------------
	DoNestItems:function(packMethod)
	{
		var binIndex = 0;	
		var unfitItems = this.PrepareForPacking();
		var itemCount = unfitItems.length;
		var ret = (itemCount > 0);
		
		if( ret )
		{
			// reset pack status and the window after each run
			this.uiLayout.ResetPackStatus();
			this.RemoveBins();		
			
			// now remove all bins except for the first one
			// TODO: add code to handle situations where none of the blocks will fit .
			// now it will hang the script
			while(true)
			{
				var curBin = this.bins[binIndex];
				unfitItems = curBin.Pack(unfitItems,packMethod);
				
				if(unfitItems == null)
				{
					break;
				}
				if(this.bins.length > itemCount)
				{
					//  this means that we could not fit some items at all - and now we have more bins than items
					// get out!!
					this.uiLayout.DisplayPackError("Some items would not fit, giving up!");
					//remove all bins that we created so far
					// reinitialize the packer
					this.bins.length = 1;
					this.bins[0].Init();
					ret = false;
					break;
				}
				binIndex++;
				
				if(this.bins.length <=binIndex)
				{
					var newBin = new Bin(this.uiLayout,this.nextBinId++);
					this.bins.push(newBin);				
				}					
			}
			//now that we fit all the items - lets' prune identical bins
			this.RemoveDuplicateBins();			
		}
		return ret;
	},
	//--------------
	// count all instances in all elements
	TotalInstanceCount:function ()
	{
		// return total number of print instances in all layout elements
		var ret = 0;
		for( var i = 0;i < this.elements.length; ++i )
		{
			ret += this.elements[i].instances.length;
		}
		return ret;
	},
	//----------------------------------
	// sometimes elements have names - when created from json array
	AddElement:function(elementName)
	{
		
		var myElem = new PrintElement(this.uiLayout);
		if(typeof elementName !='undefined')
		{
			myElem.name = elementName; 
		}
		
		if(this.elements.length > 0 && typeof elementName == 'undefined')
		{
			myElem.name+="-"+this.elements.length;
		}
		this.elements.push(myElem);
		return myElem; // when items are added from json they need to be update
	},
	
	RemoveElement:function(i) 
	{
		this.elements.splice(i,1);
	},
	
	CloneInstance:function(elemIndex,instIndex) 
	{
		if(IsValidIndex(elemIndex,this.elements) && 
		   IsValidIndex(instIndex,this.elements[elemIndex].instances))
		{
			var orient = this.elements[elemIndex].instances[instIndex].orientation;
			this.elements[elemIndex].addLayoutInstance(orient);
		}				
		
	},			
	// remove the isntance that belongs to a given element
	RemoveInstance:function(elemIndex,instIndex)
	{
		try
		{					
			if(IsValidIndex(elemIndex,this.elements) && 
			  IsValidIndex(instIndex,this.elements[elemIndex].instances))
			{
				this.elements[elemIndex].removeLayoutInstance(this.elements[elemIndex].instances[instIndex]);					
				DisEnableElement("#ist_efit-btn" ,this.TotalInstanceCount());						
			}
			
		}
		catch(e)
		{
			
		}		
	},
	
	UpdateServerData:function() 
	{
		
		if($(".ist_stocklength").html() > 0) {

			// Send a JSON-compliant string to the server
			var upPut = "{";
			upPut += "\"runcount\":\"" + $(".ist_stocklength").html() + "\",";
			upPut += "\"gutter\":\"" + $(".ist_cutmargin select").val() + "\",";
			upPut += "\"margin\":\"" + $(".ist_stockmargin input").val() + "\",";
			upPut += "\"width\":\"" + $(".ist_stockwidth input").val() + "\",";
			upPut += "\"height\":\"" + $(".ist_platelength input").val() + "\",";
			upPut += "\"perimeter\":\"" + this.uiLayout.GetCumulativePerimeterFt() + "\",";
			// if calculating tiles media count will be 1
			upPut += "\"media_count\":\"" +(this.GetTotalNumBins()) + "\",";
			if(this.uiLayout.calcTiles)
			{
				upPut += "\"tile_count\":\"" +(this.GetNumTiles()) + "\",";
				upPut += "\"linear_ft\":\"" +(this.GetStats(STAT_LINEAR_FEET)) + "\",";
				upPut += "\"sq_ft\":\"" +(this.GetStats(STAT_SQUARE_FEET)) + "\",";				
			}
			
			upPut += "\"elements\": [";
			for(var i in this.elements) {
				var e = this.elements[i];
				upPut += "{";
				upPut += "\"name\":\"" + e.name + "\",";
				upPut += "\"width\":\"" + e.width + "\",";
				upPut += "\"height\":\"" + e.height + "\",";
				upPut += "\"count\":\"" + e.desiredCount + "\",";
				upPut += "\"instances\": [";
				for(var x in e.instances) {
					var y = e.instances[x];
					upPut += "{";
					upPut += "\"orientation\":\"" + y.orientation + "\",";
					upPut += "\"left\":\"" + y.left + "\",";
					upPut += "\"top\":\"" + y.top + "\"";
					upPut += "},";
				}
				upPut = upPut.replace(/\,+$/, '');
				upPut += "]";
				upPut += "},";
			}
			upPut = upPut.replace(/\,+$/, '');
			upPut += "]";
			upPut += "}";
		
			// alert(upPut);
		
			$.ajax({
				type: "POST",
				url: "layoutcalc.lasso",
				data: upPut,
				success: function(msg){
					// alert( "Data Saved: " + msg );
				}
			});
		}
	},
	// adjust the count of instancesbased on UI input
	AdjustInstanceCount:function(countField, printElIdx)
	{
		var printEl = this.elements[printElIdx]; 
		// save current value which is the count of instances in this printElement
		var oldVal = printEl.instances.length;
		
		var newVal = countField.val();
		// enforce positive values
		if(!isNaN(newVal) && newVal >=0)
		{
			// update statistics
			
			// now  figure out the delta
			var delta = newVal-oldVal;
			if(delta > 0)
			{
				while(delta--)
				{
					printEl.addLayoutInstance("auto");
				}
			}
			else
			{
				while(delta++ < 0)
				{
					printEl.removeLayoutInstance(printEl.instances[printEl.instances.length-1]);
				}
			}
			//enable or disable the fit button based on the total count of all layout instances in all print elements
			DisEnableElement("#ist_efit-btn" ,this.TotalInstanceCount());
		}
		else
		{
			// restore old value
			inputElem.val(oldVal);
		}
	},
	// return an array of all instances in all elements that belong to a given bin
	FindInstancesByBinId:function(binId)
    {
		var ret = new Array();
		for( var i = 0;i < this.elements.length; ++i )
		{
			var curElement = this.elements[i];
			for(var k = 0; k< curElement.instances.length;++k)
			{
				if(curElement.instances[k].binId == binId)
				{
					ret.push(curElement.instances[k]);
				}
			}
		}
		return ret;
    },
    // prepare items for packing
    PrepareForPacking:function()
    {
    	var unfitItems = new Array();
    	
    	// unroll all items into one big array and bin pack it
		
		for( var i =0; i < this.elements.length;++i)
		{
			var curEl = this.elements[i];
			// 
			if(!this.uiLayout.ElementFits(curEl))		
			{
				// skip elements that will not fit in the bin because of their dimensions
				this.uiLayout.DisplayPackError("Element \""+curEl.name + "\" does not fit, skipping");
				continue;				
			}
			for(var k = 0; k < curEl.instances.length;++k)
			{								
				curEl.instances[k].PrepareForPacking();
				unfitItems.push(curEl.instances[k]);
			}
		}
		return unfitItems;
    },
    // remove bin at specified index or all except first one if no index specified
    RemoveBins:function(index)
    {
    	var numToRemove  = (typeof index =='undefined'? this.bins.length-1 : 1);
    	if(numToRemove > 0)
    	{
    		var startIndex =  (typeof index =='undefined'? 1 : index);
    	
    		this.bins.splice(startIndex, numToRemove);
    		// update next bin id
    		// bin ids are closely coupled with tab indices so need to keep them in sync
    	}
    	this.nextBinId = this.bins.length;
    },
    //---------------------
    // Prepare all intances once for packing
    
    //return a bin at index. Used by BinTabManager to draw the bin info in tab
    GetBinAt:function(index)
    {
    	return( IsValidIndex(index,this.bins) ? this.bins[index]: null);   	
    },
    GetBinDesc:function(index)
    {
    	var bin = this.GetBinAt(index);
    	return (bin == null ? "" : bin.GetDesc());
    },
    // remove identical bins
    RemoveDuplicateBins:function()
    {
    	var prunedList = new Array();
    	
    	for (var i = 0; i < this.bins.length;++i)
    	{
    		var curBin = this.bins[i];
    		if(!curBin.isDuplicate)
    		{
    			this.CheckForDuplicates(curBin,i+1);
    			prunedList.push(curBin);
    		}
    	}
    	// if there were dups the bin ids must be updated so they are correctly 
    	// drawn in tabs - there is a 1:1 mapping between the tab ids and bin ids
    	// also all items ids must be updated 
    	if(prunedList.length < this.bins.length)
    	{
    		this.UpdateBinIds(prunedList);
    	}
    	this.bins.length = 0;
    	this.bins = prunedList;
    	
    	// need to renumber the bin ids as they have shifted because sume items were removed
    },
    CheckForDuplicates:function(theBin,startIndex)
    {
    	for(var i = startIndex; i < this.bins.length; ++i)
    	{
    		var curBin = this.bins[i];
    		if(theBin.IsIdenticalBin(curBin))
    		{
    			curBin.isDuplicate = true;
    			// set unused bins'ids to -1 forcing all instances that are in it to have a bin id of -1
    			// this will ensure that during drawing we don't get  instances drawn in wrong binsS
    			curBin.UpdateBinId(-1);
    			theBin.numDuplicates++;
    		}
    	}
    	if(theBin.numDuplicates > 0)
    	{
    		theBin.dupRangeStart = startIndex;
    	}
    },
    // update bin ids and ids of all items in bins
    UpdateBinIds:function(binList)
    {
    	for (var i = 0 ; i < binList.length; ++i)
    	{    		
    		binList[i].UpdateBinId(i);    		
    	}
    },
    PackBestFit:function()
    {
    	//var packResults = new Array();
    	var bestMethod = 0;
    	var leastBins = -1; // least num bins it took to pack all items    	
    	
    	for(var i = 0; i <= RectContactPointRule; ++i )
    	{
    		// don't bother if fit fails
    		if(this.DoNestItems(i))
    		{
	    		var curTotalBins = this.bins.length;// bins without dups
    			
    			// now compare the current results to the previous    	
	    		// first time around there is nothing to compare with - just initialize
	    		if(leastBins == -1)
	    		{
	    			leastBins = curTotalBins;
	    			bestMethod = i;
	    		}
	    		else
	    		{    			
    				if(curTotalBins < leastBins)
    				{
    					// save the best occupancy and method used to get it
    					leastBins = curTotalBins;
    					bestMethod = i;	  
    				}
	    		} 
    		}
    	}
    	// now re-nest based on the best occupancy
    	// skip if the last method produced the best results - 
    	// everything is already packed 
    	if(bestMethod!=(i-1))
    	{
    		this.DoNestItems(bestMethod);
    	}
    	
    },    
    //---------------------------
    //return cumulative occupancy of the bin set after packing
    GetCumulativeOccupancy:function()
    {
		var ret = 0;
		for(var i =0; i < this.bins.length;++i)
		{
			var curBin = this.bins[i];
			if(curBin!=null && curBin.packer!=null)
			{
				ret+=curBin.packer.Occupancy();
			}
		}
		return ret;		
    },    
    //--------------------------------
    // return total waste percentage in this job
    GetCumulativeWaste:function()
    {
    	return 100.00 - (this.GetCumulativeOccupancy() * 100);
    },
    //get num bins + duplicates
    GetTotalNumBins:function()
    {
    	var ret = 0;
		for(var i =0; i < this.bins.length;++i)
		{
			var curBin = this.bins[i];
			ret+=curBin.numDuplicates +1;// count the bin itself			
		}
		return ret;
    },
    GetNumTiles:function()
    {
    	var ret = 0;
    	for(var i=0; i < this.elements.length; ++i)
    	{
    		ret += this.elements[i].instances.length -1;
    	}
    	return ret;
    	
    },
    NestForTiles:function()
    {
    	 /*
    	 * 1. Determine how many images fit on the media. For the most part there will be just one but may be more.
    	 * Need to determine what to do if there is more than one image. How do we display them?
    	 * We should probably create another bin but call it the same name
    	 * 2. Tile each image
    	 * The print element in this case represents an image to be tiled. Initially it has just one element instance the size of the image,
    	 * 
    	
    	// Use a shortcut to determine if all  images fits in the media. if they don't - we need to bin pack into multiple bins
    	// this is very unlikely with tiles but still
    	// punt for now.
    	
    	var elementsArea = this.GetTotalElementsAreaPx();
    	var mediaArea = this.uiLayout.binHeightPx * this.uiLayout.binWidthPx; 
        
    	if(elementsArea >=mediaArea)
    	{
    		// need to bin pack images.
    		// Temporarily turn off calcTiles flag not to confuse the code that prepares the packer.
    		// TODO - this is very unlikely - punt for now
    	}
    	else
    	*/
    	
    	/* make sure bins are set up correctly
    	 * for tiles we have one bin called overview and another called details   	
    	*/
    	if(this.bins.length <=1)
    	{
    		this.bins[0].name = "Overview";
    		var detailsBin = new Bin(this.uiLayout,this.nextBinId++);
    		detailsBin.name = "Details";
    		this.bins.push(detailsBin);		
    	}
    	// everything fits in one roll - tile the print elements (i.e images). Most likely there is only one per roll
    	
		for ( var i = 0;i < this.elements.length; ++i)
		{
			this.elements[i].Tile();
		}
		// this code does not deal with multiple images
		// TODO
    	
    	return true;
    	
    },
  //-----------------------
	DoNestItems_Tiles_Unused2:function(packMethod)
	{
		// only one bin always
		var theBin = this.bins[0];
		// remove element instances that may've been created in the previous runs
		// get the first instance prepped
		this.elements[0].PrepareForTileNesting();
		var tiles = this.PrepareForPacking();		
		var ret = (tiles.length > 0);
		
		if(ret )
		{
			// reset pack status and the window after each run
			this.uiLayout.ResetPackStatus();
			this.RemoveBins();		
			
			// now remove all bins except for the first one
			// TODO: add code to handle situations where none of the blocks will fit .
			// now it will hang the script
			while(theBin.Pack(tiles,packMethod) == null)
			{				
				
				//we successfully fit a block. add another, and see if it fits.
				// with tiles there can be only ONE print element
				var newInstance = this.elements[0].addLayoutInstance();
				newInstance.PrepareForPacking();
				tiles.push(newInstance);				
			}
			// we can only break out of the loop if pack failed to fit the last item, so pop it
			if(tiles.length  > 1 )
			{
				var el0 = this.elements[0];
				var lastInstance = el0.instances[el0.instances.length-1];
				var origInstanceHeight = lastInstance.height;
				// adjust the height of the instance that did not fit
				lastInstance.height = this.uiLayout.binHeightPx- ((el0.instances.length-1) * origInstanceHeight);
				// don't add if the height turns out  to be zero
				if(lastInstance.height > 0)
				{
					// need to set up the top left value for it
					lastInstance.left = 0 + this.uiLayout.marginPx + "px";
					// TODO: factor in the overlap (i.e gutter)
					// important: without "px" the drawing code breaks
					lastInstance.top = (el0.instances.length -1) * origInstanceHeight + this.uiLayout.gutterPx +  "px";
					lastInstance.isPartialTile = true;
					
				}
				else
				{
					// otherwise remove it
					this.elements[0].removeLayoutInstance(tiles.pop());
				}
				
			}
			
		}
		return ret;
	},
	DoNestItems_Tiles_Unused1:function(packMethod)
	{
		// only one bin always
		var theBin = this.bins[0];
		// remove element instances that may've been created in the previous runs
		// get the first instance prepped
		this.elements[0].PrepareForTileNesting();
		var tiles = this.PrepareForPacking();		
		var ret = (tiles.length > 0);
		
		if(ret )
		{
			// reset pack status and the window after each run
			this.uiLayout.ResetPackStatus();
			this.RemoveBins();		
			
			// now remove all bins except for the first one
			// TODO: add code to handle situations where none of the blocks will fit .
			// now it will hang the script
			while(theBin.Pack(tiles,packMethod) == null)
			{				
				//unfitItems = theBin.Pack(tiles,packMethod);
				
				/*if(unfitItems != null)
				{
					// the bin is full
					// pop the last instance and bail
					tiles.pop();
					break;
				}*/
				/*
				if(this.bins.length > itemCount)
				{
					//  this means that we could not fit some items at all - and now we have more bins than items
					// get out!!
					this.uiLayout.DisplayPackError("Some items would not fit, giving up!");
					//remove all bins that we created so far
					// reinitialize the packer
					this.bins.length = 1;
					this.bins[0].Init();
					ret = false;
					break;
				}*/
				//we successfully fit a block. add another, and see if it fits.
				// with tiles there can be only ONE print element
				var newInstance = this.elements[0].addLayoutInstance();
				newInstance.PrepareForPacking();
				tiles.push(newInstance);				
			}
			// we can only break out of the loop if pack failed to fit the last item, so pop it
			if(tiles.length  > 1 )
			{
				this.elements[0].removeLayoutInstance(tiles.pop());
			}
			
		}
		return ret;
	},
	PackBestFit_Tiles:function()
	{
		this.DoNestItems_Tiles(RectContactPointRule);
	/*			
		var theBin = this.bins[0]; // only 1 bin
		var bestMethod = 0;
    	var wastePct = 100.00; // least num bins it took to pack all items    	
    	
    	for(var i = 0; i <= RectContactPointRule; ++i )
    	{
    		// don't bother if fit fails
    		if(this.DoNestItems_Tiles(i))
    		{
    			if(theBin.GetWaste() < wastePct)
    			{
    				wastePct = theBin.GetWaste();
    				bestMethod = i;
    			}
    		}
    	}
    	// now re-nest based on the best occupancy
    	// skip if the last method produced the best results - 
    	// everything is already packed 
    	if(wastePct < 100.00)
    	{
	    	if(bestMethod!=(i-1))
	    	{
	    		this.DoNestItems_Tiles(bestMethod);
	    	}
    	}
    	else
    	{
    		this.uiLayout.DisplayPackError("The tile does not fit on media!");
    	}
    	*/
	},
	// return various statistics frtom all elements in feet
	//
	GetStats:function(curStat)
	{
		var ret = 0;
		for(var i = 0; i < this.elements.length; ++i)
		{
			var curElement = this.elements[i];
			var val = 0;
			// becuse of partial tiles need to do this manually
			switch (curStat)
			{
			case STAT_LINEAR_FEET:
				
				val = (curElement.getHeightIn() * (curElement.instances.length-1));
				break;
			case STAT_SQUARE_FEET:
				// factor in the overlap when calculating area
				val = curElement.GetCumulativeAreaIn();
				// ((curElement.getWidthIn() + this.uiLayout.gutterIn) * curElement.getHeightIn()) * (curElement.instances.length-1 );
				break;
			default :
				break;
			}
			ret += val;
		}
		// everything is in inches, convert to feet
		return (ret /12);
	},
	// returns cumulative area of all elements in pixels
	GetTotalElementsAreaPx:function()
	{
		var ret = 0;
		for(var i =0; i < this.elements.length; ++i)
		{
			ret += (this.elements[i].width * this.elements[i].height);
		}
		return ret;
	},
	//return the cumulative perimeter of all items
	GetCumulativePerimeterIn:function()
	{
		var ret = 0;
		for (var i = 0; i <this.elements.length; ++i)
		{
			ret+=this.elements[i].GetCumulativePerimeterIn();
		}
		return ret;
	},
	// there ios only one element with tiles
	HandlePreviewTileClick:function(isNext)
	{
		this.elements[0].HandlePreviewTileClick(isNext);
	},

//---
};