// this class represents a print element 
// some globals
var MIN_TILE_WIDTH = 60;

PrintElement = function(uiLayout) 
{
  this.ctor(uiLayout);
};

PrintElement.prototype = {

  ctor: function(uiLayout) 
  {
	  this.uiLayout = uiLayout;
   
   	this.deletebutton = "<span class=\"ui-icon ui-icon-circle-minus icon ist_deleteelement\">Delete<\/span>";
	this.addbutton = "<span class=\"ui-icon ui-icon-circle-plus icon addelement\">Clone<\/span>";
	this.name = "unnamed";
	this.width = 0;
	this.height = 0;	
	this.desiredCount = 0;
	this.previewFile= "";// preview file that comes from the server
	this.instances = new Array();
	this.drawLastTile = false; // used to cycle through full and partial tile when drawing tiles
	this.curTileIndex = 1; // used for tiles
	this.xposAdjustment = -1; // 
	this.fullDisplayTileRect = new Rect();
	this.partialDisplayTileRect = new Rect();
	
	
  },
	
  	setWidth:function(val) 
  	{
		this.width = (val * this.uiLayout.pxRatio);
		// this will be used as a constraint for drawing	
		// update the scale factor		
	},
		
	setHeight:function(val) 
	{
		this.height = (val * this.uiLayout.pxRatio);
		
	},	
	//return real wdidth and height in inches
	getWidthIn:function()
	{
		return (this.width / this.uiLayout.pxRatio);
	},
	getHeightIn:function()
	{
		return (this.height / this.uiLayout.pxRatio);
	},
	// Add element instance of the print element to the list of instances
	addLayoutInstance:function(orient) 
	{
		var newInstance = new ElementInstance(this);
		// save the parent -needed for bin packing
		newInstance.parent = this;
		newInstance.setOrientation(orient);
		// Don't allow new objects to be inserted beyond the 
		// right-most edge of the window.
		//if((this.uiLayout.yCursor + parseInt(this.width)) > parseInt(this.uiLayout.layoutWindow.width())) {
		//	this.uiLayout.yCursor = (parseInt(this.uiLayout.layoutWindow.width()) - parseInt(this.width));
	//	}
		// Make the layout window grow vertically as the top-offset inserts
		// new instances that extend below the bottom of the layout window.
		//var elemDisplayHeight = parseInt(this.height);
		//if(newInstance.orientation == "landscape") 
	//	{
	//		elemDisplayHeight = parseInt(this.width);
	//	}
		
		// this pushes the window down - maybe not what we want  now that packing is automatic
		// this.uiLayout.GrowLayoutWindow(elemDisplayHeight);
		
		//newInstance.top = (this.uiLayout.xCursor + "px");
		//newInstance.left = (this.uiLayout.yCursor + "px");
		newInstance.top = newInstance.left = 0;
		newInstance.depth = 0; //this.uiLayout.zCursor;	
		
		// save in the instance - it is used to 
		this.instances.push(newInstance);
		// Calculate offset for next instance
		//this.uiLayout.UpdateCursors();
		
		// update desired count
		// with tiles the first instance is the "image" that is being tiled, so dont count it
		if(this.uiLayout.calcTiles)
		{
			desiredCount = (this.instances.length-1);
		}
		else
		{
			this.desiredCount++;
		}
		
		// some code needs this, i.e pack_tiles code
		return newInstance;
	},
	//-----------remove layout instance at index
	// and update instace count
	removeLayoutInstance:function(instance)
	{
		instIndex = this.instances.indexOf(instance);
		
		if(instIndex >=0)
		{
			this.instances.splice(instIndex,1);
			this.desiredCount--;
		}
	},
//--------------------------------	
	drawElementControl:function(i,s) 
	{
		var output = "";
		output += "<tr class=\"ist_econtrol\">";
		output += "<td class=\"ist_eswitches\">";
		if(i == s) {
			output += this.addbutton;
		}
		if(s != 1) {
			output += this.deletebutton;
		}
		output += "<\/td>";
		output += "<td class=\"ist_ename\"><input type=\"text\" name=\"ist_ename\" value=\"" + this.name + "\"><\/td>";
		output += "<td class=\"ist_ewidth\"><input type=\"text\" name=\"ist_ewidth\" value=\"" + (this.width / this.uiLayout.pxRatio) + "\"><\/td>";
		output += "<td class=\"ist_eheight\"><input type=\"text\" name=\"ist_eheight\" value=\"" + (this.height / this.uiLayout.pxRatio) + "\"><\/td>";
		output += "<td class=\"ist_ecount\"><input type=\"text\" name=\"ist_ecount\" value=\"" + this.desiredCount + "\"><\/td>";
		output += "<\/tr>";
		$("div.elements table tbody").append( output );
	},
	//----------------------------
	// Draw all layout instances of this element.
	// Optionally take into account binId that was passed in
	drawLayoutControls:function(elemIndex, binId) 
	{
		if(this.width && this.height) 
		{			
			if(this.uiLayout.calcTiles)
			{
				this.DrawLayoutControls_Tiles(elemIndex,binId);
			}
			else
			{
				for(var instIndex in this.instances) 
				{
					// draw if : binId is undefined or it is defined AND instance bin Id == binId
					if(typeof  binId =='undefined' || ((typeof binId !='undefined')  && (this.instances[instIndex].binId == binId)))
					{					
						this.instances[instIndex].drawLayoutControl(elemIndex,instIndex,this.name,this.instances.length);
					}
				}
			}
		}
	},
	// populate this element from json
	InitFromJson:function(jsonElem)
	{
		this.setWidth(jsonElem.width);
		this.setHeight(jsonElem.height);
		
		this.SetupPreviewFileName();	
		for(var i =0; i <jsonElem.count;++i)
		{
			this.addLayoutInstance("auto");
		}
	},
	// derive preview file name from the file name
	// the file must have an extension!
	SetupPreviewFileName:function()
	{
		var dotPos = this.name.indexOf(".",0);
		if(dotPos >0)
		this.previewFile = this.name.substring(0,dotPos) +  "_preview.jpg";
	},
	// remove all layout instances except the first one
	PrepareForTileNesting_Unused:function()
	{
		if(this.instances.length > 1 )
		{
			this.instances.splice(1,this.instances.length-1);
		}		
		this.desiredCount = 1;		
	},
	// return total height of all layout instances.Skip the first one as it represents the image
	GetCumulativeLengthIn:function()
	{
		var ret = 0;
		for( var i = 1; i < this.instances.length; ++ i)
		{
			var curInstance =  this.instances[i];
			ret += curInstance.getHeightIn();
			
		}
		return ret;
	},
	//Skip the first one as it represents the image
	GetCumulativeAreaIn:function()
	{
		var ret = 0;
		var gutterIn = parseInt(this.uiLayout.gutterIn);
		for( var i = 1; i < this.instances.length; ++ i)
		{
			var curInstance =  this.instances[i];
			ret += ((curInstance.getWidthIn() + gutterIn  )*  curInstance.getHeightIn());			
		}
		return ret;
	},
	// special preparation for tile packing
	PrepareInstanceForTilePacking:function(instance)
	{
		instance.PrepareForPacking(); 
		// adjust the width to the width of the media taking into account margin and gutter.		
		instance.width = (this.uiLayout.binWidthPx - this.uiLayout.marginPx ) + this.uiLayout.gutterPx;
	},
	// Tile the image that this element represents
	Tile:function()
	{
		this.CleanupInstances(false); // don't remove the first element		
		this.uiLayout.ResetPackStatus();
		// reset all variables used to draw tile details
		this.ResetTileDetailsVars();
		
		var tileWidth = (this.uiLayout.binWidthPx -(this.uiLayout.marginPx*2)) + this.uiLayout.gutterPx;	
		// see how many tiles are needed to cover the width
		var numTilesNeeded = this.width/tileWidth;
		var partialTileWidth = 0;
		var newInstance = null;
		// tile width <0 - default to the image width
		if(numTilesNeeded < 1)
		{
			tileWidth = this.width;
			numTilesNeeded = 1;
		}
		if(numTilesNeeded %1 !=0)
		{
			//determine the width of the partial tile
			// don't force to integer for now - maybd we want more precision in the width |0
			partialTileWidth = this.width - ((numTilesNeeded |0 ) * tileWidth);			
		}
		// now add instances that represent full tiles
		for(var i = 0; i <( numTilesNeeded |0); ++i)
		{
			newInstance = this.addLayoutInstance();
			// if numTilesNeeded <=1 this means that the width of the image is less than the width of the bin
			// in this case there will be only one tile. Use the width of the image as the width of the print element
			if(numTilesNeeded >1 )
			{
				this.PrepareInstanceForTilePacking(newInstance);
			}
		}
		// and add partial tile if necessary
		if(partialTileWidth > 0)
		{
			newInstance = this.addLayoutInstance();
			this.PrepareInstanceForTilePacking(newInstance);
			newInstance.width = partialTileWidth;
			newInstance.isPartialTile = true;
		}
		this.AdjustDisplayDimensions((partialTileWidth > 0));
		this.PrepareDisplayTiles();
		
	},
	CleanupInstances:function(removeAll)
	{
		var startIndex = removeAll ? 0 : 1;
		var count = removeAll ? this.instances.length : (this.instances.length -1);
		if(count > 0 )
		{
			this.instances.splice(startIndex,count);
		}
		
		this.desiredCount = this.instances.length;	
	},
	// now that we are done packing - adjust the display dimensions of the instances.
	// first calculate the width based on the number of full instances
	AdjustDisplayDimensions:function(hasPartialTile)
	{
		
		var winWidth = this.uiLayout.displayWidth() - (this.uiLayout.marginPx * 2);
		var winHeight = this.uiLayout.displayHeight() -(this.uiLayout.marginPx * 2);
		var avgWidth = 0;
		var partialWidth = 0;
		var numTiles = this.instances.length-2; // dont count the first and last instances - the first one is the "image" and the last one is partial tile
		// this is all bogus. We cannot display the actual 54x360" tiles
		// so we only display the correct number of tiles and visually show that the last one is partial
		// first  evenly divide the width so all rects fit.
		if(numTiles > 0)
		{
			// this accounts for cases when the image width is less than he bin width
			avgWidth = winWidth / (Math.floor((numTiles+1))); 	
			if(hasPartialTile)
			{
				// tnen add half the average width to every rect 
				avgWidth+= (avgWidth/2)/numTiles;
				// remainder is the width of th epartial tile
				partialWidth = winWidth - (avgWidth*numTiles);
			}
		}
		else
		{
			// this means that the image width is less than the width of the roll
			avgWidth = this.width;
		}
		// start with the top left of the enclosing image
		var nextX= 0;
		for(var i = 0; i < this.instances.length; ++i)
		{
			var curInstance = this.instances[i];
			if(i == 0)
			{
				curInstance.top = curInstance.left = this.uiLayout.marginPx;
				nextX=curInstance.left;
			}
			else
			{
				curInstance.top = this.instances[0].top;			
				curInstance.left = nextX;
				curInstance.displayHeight = winHeight;
				curInstance.displayWidth = (curInstance.isPartialTile ? partialWidth : avgWidth);
				nextX+=curInstance.displayWidth;	
			}
		}
	},
	GetCumulativePerimeterIn:function()
	{
		var ret = 0;
		if(this.uiLayout.calcTiles)
		{
			// skip first "image" element
			for(var i = 1; i < this.instances.length; ++i)
			{
				var curInstance = this.instances[i];
				ret += (((curInstance.getWidthIn() *2 ) + (curInstance.getHeightIn() * 2)));
			}
		}
		else
		{
			ret = ((this.getWidthIn() *2 ) + (this.getHeightIn() * 2)) * this.instances.length;
		}
		return ret;
	},
	DrawLayoutControls_Tiles:function(elemIndex,binId)
	{
		
		if(binId == 0)
		{
			// it's an overview - draw as normal
			for(var instIndex in this.instances) 
			{
				// draw if : binId is undefined or it is defined AND instance bin Id == binId
				if(typeof  binId =='undefined' || ((typeof binId !='undefined')  && (this.instances[instIndex].binId == binId)))
				{					
					this.instances[instIndex].drawLayoutControl(elemIndex,instIndex,this.name,this.instances.length);
				}
			}
		}
		else
		{
			this.DrawDetails(elemIndex);
		}		
	},
	DrawDetails:function(elemIndex)
	{
		// either drawing second or last tile
		//var instIndex = (this.drawLastTile ? this.instances.length-1: 1);
		//var numTiles = this.drawLastTile ? 1 : this.instances.length -2;
		
		
		// first draw nav controls
		this.instances[0].drawLayoutControl(elemIndex,0,this.name,this.instances.length);
		// now draw the tile. Navigation clicks update the curTileIndex
		
		if(IsValidIndex(this.curTileIndex,this.instances))
		{
			this.instances[this.curTileIndex].DrawDetails(elemIndex,this.curTileIndex);
		}					
	},
	UpdatePosition:function(instIndex,left,top)
	{
		// when in tile mode and the current tab is "details" (index 1) - don't update position
		if(!this.uiLayout.calcTiles || (this.uiLayout.calcTiles && this.uiLayout.binTabManager.selectedTabIdx != 1))
		{
			this.instances[instIndex].updatePosition(left,top);
		}
	},
	//moving tiles forward
	HandlePreviewTileClick:function(isNext)
	{
		// increment or decrement curr index depending on the direction		
		this.curTileIndex+= (isNext ? 1 : -1);
		// update  butttons		
		$('.ist_tilenext_image').prop('disabled',(this.curTileIndex >= this.instances.length));
		$('.ist_tileprev_image').prop('disabled',(this.curTileIndex < 1));
		
		if(isNext )
		{
			if(this.curTileIndex >= this.instances.length)
			{
				this.curTileIndex-=1;
				return;
			}			
		}
		else
		{
			if(this.curTileIndex < 1 )
			{
				this.curTileIndex = 1;
				return;
			}
		}
		
		// now calculate next position and save it for the drawing code
		// this is only done when we have the image width and both nav buttons are enabled.
		var imageWidth = this.uiLayout.GetTileImageWidth();
		
		//if(this.xposAdjustment == -1)
		{
			//var partialTileWidth = parseFloat($("#ist_hidden_partial_tile_div").width());
			//var curTileWidth = parseFloat($("#ist_tile_div").width());
			
			var partialTileWidth = this.GetPartialTileRect().width;
			var fullTileWidth = this.GetFullTileRect().width;
			this.xposAdjustment = 0;//(fullTileWidth-partialTileWidth) +50;
		}
		
		
		if( imageWidth > 0  )			
		{
			var xpos = this.uiLayout.GetTileXPos();
			var step = (imageWidth /(this.instances.length -1));
			
			xpos += (isNext? step : -step);
			xpos = xpos.toFixed(2);
			
			// when going forward - subtract adjustment from xpos, otherwise add
			//xpos -= (isNext ? this.xposAdjustment : -this.xposAdjustment);
			if(xpos < 0 )
			{
				xpos = 0;
			}
			// if the image has been saved- calculate next position			
			 this.uiLayout.SetTileXPos(xpos);			
		}
				
	},
	// make sure to reset all variables used for drawing tile details
	ResetTileDetailsVars:function()
	{
		this.xposAdjustment = -1;
		this.curTileIndex = 1;
		this.uiLayout.SetTileXPos(0);
		this.uiLayout.SetTileImageWidth(0);		
		//
		this.fullDisplayTileRect.Reset();
		this.partialDisplayTileRect.Reset();
		
	},
	SetDisplayTileDimensions:function(widthIn,heightIn,tileRect)
	{
		// convert everythig to rects
		
		tileRect.height = heightIn * this.uiLayout.ratioMultipliler;
		tileRect.width =  widthIn * this.uiLayout.ratioMultipliler;
		var enclosingRect = new Rect();
		enclosingRect.width = this.uiLayout.layoutWindow.width() - (TILE_NAV_IMAGE_WIDTH*2) ;
		enclosingRect.height = this.uiLayout.layoutWindow.height();
		
		
		
		// make sure it fits in the layout window
		if(tileRect.height > enclosingRect.height || 
		   tileRect.width > enclosingRect.width || 
		   tileRect.width < MIN_TILE_WIDTH)
		{
			if(tileRect.width < MIN_TILE_WIDTH)
			{
				tileRect.width = MIN_TILE_WIDTH;
			}
			else
			{
				enclosingRect.height -=40; // the height of the tile label div
				tileRect.Scale(enclosingRect);
			}
			
		}	
	},
	// calculate display dimensions of display tiles
	PrepareDisplayTiles:function()
	{
		//prepare display  tile dimensions
		var width;
		var height;
		
		if(IsValidIndex(1,this.instances))
		{
			 width = this.instances[1].getWidthIn();
			 height = this.instances[1].getHeightIn();
			 this.SetDisplayTileDimensions(width,height,this.fullDisplayTileRect);
		}
		// check partial tile
		if(IsValidIndex(this.instances.length-1,this.instances))
		{
			width = this.instances[this.instances.length-1].getWidthIn();
			height = this.instances[this.instances.length-1].getHeightIn();
			this.SetDisplayTileDimensions(width,height,this.partialDisplayTileRect);
		}
		else
		{
			// just one tile
			this.partialDisplayTileRect.Copy(this.fullDisplayTileRect);
		}
	},
	//wrapper functions for full and partial tile dimensions
	GetPartialTileRect:function()
	{	
		return (this.partialDisplayTileRect);		
	},
	// all tiles except the last one are full tiles
	GetFullTileRect:function()
	{
		return (this.fullDisplayTileRect);		
	}
	
	
	
	

};//Class End