// this class represents a print element instanc in the layout

var _startPos =10;
ElementInstance = function(parent) 
{
  this.ctor(parent);
};

ElementInstance.prototype = {

  ctor: function(parent) 
  {
	this.parent = parent;
	this.uiLayout = parent.uiLayout;
	this.top = 0;
	this.left = 0;
	this.depth = 10;
	this.orientation = "portrait";	
	this.initialOrientation = this.orientation; //save for the packer
	this.binId = 0; // always place in bin 0 by default
	this.isPartialTile = false; // used for partial tiles
	this.x = 0;
	this.y = 0;
	
	// width and height are used to calculate placeent in the bin
	// display width and height are used for drawing
	this.width = parent.width;
	this.height = parent.height;
	this.displayWidth =  this.width;
	this.displayHeight = this.height;
	
  },
  	//DO NOT call this when the object is rotated
	// this is only called when the object is initialized
	setOrientation:function (orient) 
	{
		if(orient == "landscape") {
			this.orientation = "landscape";
		}
		else {
			this.orientation = "portrait";
		}
		this.initialOrientation = this.orientation;				
	},
	//------------------
	toggleOrientation:function () 
	{
	
		if(this.orientation == "portrait") 
		{
			
			this.orientation = "landscape";
		}
		else 
		{
			this.orientation = "portrait";
		}
	},
	/*
	drawLayoutControl:function (elemIndex,instIndex,name,instCount) 
	{
		if(this.width >0  && this.height> 0) 
		{
			// we never want to grow the rects past the original width and height.
			// if plate size gets smaller the block size grows bigger 		
			
			var width = this.width;
			if(width > this.displayWidth)
			{
				width = this.displayWidth;
			}  
			var height = this.height;
			if(height > this.displayHeight)
			{
				height = this.displayHeight;
			}
			var top = this.top;
			if(top > 0)
			{
				top -= (this.height - this.displayHeight);
			}
			var left = this.left;
			if(left > 0)
			{
				left -=(this.width - this.displayWidth);
			}
		
		
			var output = "";
			output += "<div class=\"ist_instanceCutMargin ui-widget-content\" style=\"width:";
			output+= (width + (this.uiLayout.gutterPx * 2) - 2);
			
			output += "px;height:";
			output += (height + (this.uiLayout.gutterPx * 2) - 2);
			
			output += "px;position:absolute;top:" + top + ";left:" + left + ";\">";
			output += "<div class=\"instance\" style=\"width:";
			output += (width - 2);
			
			output += "px;height:";
			output += (height - 2);
			
			output += "px;margin:" + (this.uiLayout.gutterPx - 1) + "px;\">";
			output += "<h3>" + name + "<\/h3>";
			output += "<span class=\"ui-icon ui-icon-circle-arrow-e ist_rotateswitch icon\">Rotate<\/span>";
			output += "<span class=\"ui-icon ui-icon-circle-plus ist_cloneswitch icon\">Clone<\/span>";
			if(instCount > 1) {
				output += "<span class=\"ui-icon ui-icon-circle-minus ist_deleteswitch icon\">Delete<\/span>";
			}
			output += "<\/div>";
			output += "<\/div>";			
			
			$(ID_LAYOUT_RESIZABLE).append( output ).children().last().data("elemIndex",elemIndex).data("instIndex",instIndex);					
		}
	}*/
	
	/*  
	 * original
	 
	drawLayoutControl:function (elemIndex,instIndex,name,instCount) 
	{
		if(this.width && this.height) {
			var output = "";
			output += "<div class=\"ist_instanceCutMargin ui-widget-content\" style=\"width:";
			output+= (this.width + (this.uiLayout.gutterPx * 2) - 2);
			
			output += "px;height:";
			output += (this.height + (this.uiLayout.gutterPx * 2) - 2);
			
			output += "px;position:absolute;top:" + this.top + ";left:" + this.left + ";\">";
			output += "<div class=\"instance\" style=\"width:";
			output += (this.width - 2);
			
			output += "px;height:";
			output += (this.height - 2);
			
			output += "px;margin:" + (this.uiLayout.gutterPx - 1) + "px;\">";
			output += "<h3>" + name + "<\/h3>";
			output += "<span class=\"ui-icon ui-icon-circle-arrow-e ist_rotateswitch icon\">Rotate<\/span>";
			output += "<span class=\"ui-icon ui-icon-circle-plus ist_cloneswitch icon\">Clone<\/span>";
			if(instCount > 1) {
				output += "<span class=\"ui-icon ui-icon-circle-minus ist_deleteswitch icon\">Delete<\/span>";
			}
			output += "<\/div>";
			output += "<\/div>";			
			
			$(ID_LAYOUT_RESIZABLE).append( output ).children().last().data("elemIndex",elemIndex).data("instIndex",instIndex);
			
		}
	},
	*/
	drawLayoutControl:function (elemIndex,instIndex,name,instCount) 
	{
	
		if(this.width && this.height) 
		{
			
			if(this.uiLayout.calcTiles)
			{
				this.DrawTiledInstance(elemIndex,instIndex,name,instCount);
			}
			else
			{
			
				var output = "";
				
				// outer rectangle
				output += "<div class=\"ist_instanceCutMargin ui-widget-content\" style=\"width:";
				output+= (this.width + (this.uiLayout.gutterPx * 2) - 2);
				
				output += "px;height:";
				output += (this.height + (this.uiLayout.gutterPx * 2) - 2);
				
				output += "px;position:absolute;top:" + this.top + ";left:" + this.left + ";\">";
				// this is drawn inside the outer one
				output += "<div class=\"ist_instance\" style=\"width:";
				output += (this.width - 2);
				
				output += "px;height:";
				output += (this.height - 2);
				output += "px;margin:" + (this.uiLayout.gutterPx - 1) + "px;";
				
				
				// with tiles the preview image is placed in the window background
				//output += "background-image: url(" + this.parent.previewFile + "); height:" + 				
				//this.height + "px;width:"+this.width+"px;";
				output += "background-image: url(" + this.parent.previewFile + "); background-size:100% 100%;";
				
				
				output+="\">";
				output += "<h3>" + name + "<\/h3>";
				
				// don't draw the buttons for now
				/*output += "<span class=\"ui-icon ui-icon-circle-arrow-e ist_rotateswitch icon\">Rotate<\/span>";
				output += "<span class=\"ui-icon ui-icon-circle-plus ist_cloneswitch icon\">Clone<\/span>";
				if(instCount > 1) {
					output += "<span class=\"ui-icon ui-icon-circle-minus ist_deleteswitch icon\">Delete<\/span>";
				}*/
				output += "<\/div>";
				output += "<\/div>";			
				
				$(ID_LAYOUT_RESIZABLE).append( output ).children().last().data("elemIndex",elemIndex).data("instIndex",instIndex);
			}		
		}
	},
	//------------------
	updatePosition:function (left,top) 
	{
		
		this.left = left;
		this.top = top;
	},
	UpdateDisplayDimensions:function(width, height)
	{
		/* unused for now - not working right , revisit */
		this.displayWidth = width;
		this.displayHeight = height;
	},
	UpdateDimensionsAfterPack:function(node)
	{
		/* unused for now - not working right , revisit 
		if(this.width==node.height && this.height == node.width)
		{
			// block is flipped - update display dimensions
			// 
			this.UpdateDisplayDimensions(Math.min(this.displayHeight,this.height),Math.min(this.displayWidth),this.width);
		}*/
		this.width = node.width;
  		this.height = node.height;		
	},
	// init the instance for packing
	PrepareForPacking:function()
    {  	
    	// place all items in the first bin by settng bin id to 0 
    	this.binId = 0;  	
    	this.x = 0;
    	this.y = 0;	
    	this.isPartialTile = false;
		// reset to initial orientation in case the instance was rotated manualy-- not used any more
    	this.orientation = this.initialOrientation;	
		// reset to original width and height of the parent
    	this.height = this.parent.height;
    	this.width = this.parent.width;
    	
		// for tiles adjustments are done in PrintElement.Tile() function
		if(!this.uiLayout.calcTiles)		
		{			
			// if the dimension of the block + gutter exceeds the bin - don't increase
	    	// it. This takes care of cases where an item has the same width or height as the bin
			this.height+= (this.parent.height + this.uiLayout.gutterPx < this.uiLayout.binHeightPx ? this.uiLayout.gutterPx : 0);
			this.width+= (this.parent.width + this.uiLayout.gutterPx < this.uiLayout.binWidthPx ? this.uiLayout.gutterPx : 0);		
		}
		//curInstance.prepared = true; //so this only happens once per packing
		
    },
    DrawTiledInstance:function(elemIndex,instIndex,name,instCount)
    {
    	var output = "";
    	var realHeight;
    	var realWidth;
    	
    	// drawing preview
    	if(this.uiLayout.binTabManager.selectedTabIdx == 0)
    	{
    	
			// if we are drawing tiles - need to constrain the width and the height of instance 0 the size of the display height of the tiles to the height of the window
			// in reality when in tile mode the layout represents the image that we are tiling,not the bin. The bin (or roll)
			// can be much longer
			
			 realHeight = (instIndex == 0 ? Math.min(this.height,this.uiLayout.displayHeight()) : this.height);
			 realWidth =  (instIndex == 0 ? Math.min(this.width,this.uiLayout.displayWidth()) : this.width);
		
			if(instIndex == 0)
			{
				// for encompassing image instance - need to adjust for margin
				realHeight -=(this.uiLayout.marginPx * 2);
				realWidth -=(this.uiLayout.marginPx * 2 );			
			}
			else
			{
			
				realHeight = this.displayHeight;
				realWidth = this.displayWidth;
			}
		
			// outer rectangle - drwaw with transparent bg so that the image shows
			//
			output += "<div class=\"ist_instanceCutMargin \" style=\"background-color:transparent;width:";
			output+= (realWidth + (this.uiLayout.gutterPx * 2) - 2);
			
			output += "px;height:";
			output += (realHeight + (this.uiLayout.gutterPx * 2) - 2);
			
			output += "px;position:absolute;top:" + this.top + "px;left:" + this.left + "px;\">";
			
			/* this is drawn inside the outer one */
			output += "<div class=\"ist_instance\" style=\"width:";
			output += (realWidth - 2);
			
			output += "px;height:";
			output += (realHeight - 2);
			output += "px;margin:" + (this.uiLayout.gutterPx - 1) + "px;";
		
			// with tiles the background image is only drawn for instance at index 0 which represents the image being tiled
			if(instIndex == 0 )
			{
				
				output += "background-image: url(" + this.parent.previewFile + "); background-size:100% 100%;";
			}
				
			output+="\">";
			// first instance is outer image
			if(instIndex == 0)
			{
				//output += "<h3>" + name + "<\/h3>";
			}
			else
			{
				var widthIn = this.getWidthIn();
				var heightIn = this.getHeightIn();
				// only display 2 digits after decimal point
				if(widthIn % 1!=0)
				{
					widthIn = widthIn.toFixed(2);
				}
				if(heightIn % 1!=0)
				{
					heightIn = heightIn.toFixed(2);
				}
				output +="<h3>" + widthIn +"x" + heightIn + "<\/h3>";
			}				
			output += "<\/div>";
			output += "<\/div>";
    	}
    	else
    	{
    		realWidth = this.uiLayout.displayWidth();
    		realHeight = this.uiLayout.displayHeight();
    		// this is element 0 in the details tab - prepare the  prev/next buttons
    		output=/*div id=\"ist_tile_nav\" style=\"width:" + realWidth+ "px; height:" +
    				realHeight + "px;\""+ 
    				"position:absolute;top:0px;left:0px;"+
    				
    				">" +*/
    				"<img  id=\"id_prev\" class=\"ist_tileprev_image\" src=\"images/tile_prev.png\">"+
    				"<img  id=\"id_next\" class=\"ist_tilenext_image\" src=\"images/tile_next.png\">" ;//
    				//\/div>";
    				
    	}
		
		$(ID_LAYOUT_RESIZABLE).append( output ).children().last().data("elemIndex",elemIndex).data("instIndex",instIndex);
		
	},
	getWidthIn:function()
	{
		return (this.width / this.uiLayout.pxRatio);
	},
	getHeightIn:function()
	{
		return (this.height / this.uiLayout.pxRatio);
	},
	// draw detailed tile -- unused
	DrawDetails:function(elemIndex,instIndex)
	{
		var output = "";				
		var widthIn = this.getWidthIn();
		var heightIn = this.getHeightIn();
		var tileWidth = this.isPartialTile ? this.parent.GetPartialTileRect().width : this.parent.GetFullTileRect().width;
		var divLeft = (this.uiLayout.layoutWindow.width()/2) - (tileWidth/2);
		
		// only display 2 digits after decimal point
		if(widthIn % 1!=0)
		{
			widthIn = widthIn.toFixed(2);
		}
		if(heightIn % 1!=0)
		{
			heightIn = heightIn.toFixed(2);
		}
		
		output += 
		
		"<div class=\"ist_tile_label\" >Tile " + instIndex +" of " + ( this.parent.instances.length -1)+ ": " + widthIn +"x" + heightIn + " <\/div>" +
		
		"<div id=\"ist_tile_div\" class=\"" + (this.isPartialTile ? "ist_tile" : " ist_tile" ) + "\" " +
		"style=\" left: " + divLeft + "px;\"" +
			
		">" +				
		"<canvas id=\"ist_tile_canvas\" </canvas>" + 
		"<\/div>" +
		
		this.GenerateImageLoadScript(instIndex);
		
		$(ID_LAYOUT_RESIZABLE).append( output ).children().last().data("elemIndex",elemIndex).data("instIndex",instIndex);
	},
	
	GenerateImageLoadScript:function()
	{
		
	 /* This is a generated script that draws  the image 
	  * It picks up the xpos of from the hidden input.
	  * The xpos value is updated in PrintElement:HandlePreviewTileClick() 
	  */
		var out = "<script>" +
		"var _image = new Image();" +
		"var ypos = 0;" +
		" _image.src =\"" + this.parent.previewFile + "\";"+
		"_image.onload = function(){" +
		
		"var gutterWidth = Math.max(" + (this.uiLayout.gutterPx) + ",1);" +
		"var marginWidth = Math.max(" + (this.uiLayout.marginPx) + ",1);" +
		
		"var canvas = document.getElementById(\"ist_tile_canvas\");" +
		//"var tileDiv = document.getElementById(\"ist_tile_div\");" +
		"var context = canvas.getContext(\"2d\");" +
		
		//save the image width if it 's not saved 
		"var imageWidthEl = document.getElementById(\"ist_tileimage_width\");" +
		"if(parseFloat(imageWidthEl.value) == 0){ imageWidthEl.value = _image.width;}"+
		//"alert(' image width:' + _image.width + 'imageHeight =' + _image.height );" +	
		
		"var tileWidth = "  + (this.isPartialTile ? this.parent.GetPartialTileRect().width : this.parent.GetFullTileRect().width)   + " ;"+
		"var tileHeight = " + (this.isPartialTile ? this.parent.GetPartialTileRect().height : this.parent.GetFullTileRect().height) + " ;"+
		
		/*"var tileWidth = "  + (this.isPartialTile ? 80 : 260)   + " ;"+
		"var tileHeight = " + (this.isPartialTile ? this.parent.GetPartialTileRect().height : this.parent.GetFullTileRect().height) + " ;"+*/
		
		// "alert('tileWidth =' + tileWidth  + ',tileHeight = '+ tileHeight);" +						
		//"alert('tileDiv.clientWidth = '+ tileDiv.clientWidth + ',tileDiv.clientHeight =' + tileDiv.clientHeight );" +
		 
		/* the clip width is determined by taking the width of the image and dividing it by the numnber of tiles
		 * Take into account the partial tile as well
		 */
		
		"var numFullTiles = " + ((this.parent.instances.length-2)) + ";" +
		
		"var clipWidth = (Math.min(_image.width,(_image.width/numFullTiles) + (" + this.parent.GetPartialTileRect().width + "/numFullTiles)));" + 
		/* if the clip width is greater than the image width, this  means that there is one tile that fits almost all of the area of the div
			and another one that is very narrow.
			In this case subtract the size of the full tile from the clip so that some image is left to be drawn inthe partial tile
		*/	
		"if(clipWidth>=_image.width){console.log('clip width was > image width '+clipWidth);clipWidth-=" + ((this.parent.instances.length-2 <1) ? 0 :this.parent.GetFullTileRect().width) + ";}"+
		
		"var clipHeight = _image.height;"+// "Math.min(" +this.uiLayout.layoutWindow.height() + " + 0 " + ",_image.height);" +//" + tileHeight;" +
		
		"canvas.setAttribute('width', tileWidth);" + 
		"canvas.setAttribute('height',tileHeight);" + 
		
		"var startPos = parseInt(document.getElementById(\"ist_tile_xpos\").value);"  +
		"var absolutePos = (clipWidth+startPos);"+
		"if((absolutePos) >=_image.width){console.log('WARNING:clipWidth+startPos=' + absolutePos +', greater than image width,decreasing startPos by ' + (absolutePos-_image.width));" +	
		"startPos-=(absolutePos-_image.width);"+
		"}" +
		
		"console.log('drawImage vars:'+" +
		"'\\nDebug info:\\nstartPos:'+ startPos + " +
		"'\\nclipWidth:'+clipWidth+'\\nclipHeight:'+clipHeight+'\\ntileWidth:'+tileWidth+'\\ntileHeight:'+tileHeight + '\\nimageWidth:'+_image.width);" +
	
		"try{" +
			"context.drawImage(_image, startPos, 0, clipWidth,clipHeight, 0,0, tileWidth,tileHeight);" +
		"}"+
		"catch(e){" +
			"console.log('Exception in drawImage:'+e.message +" +
			"'\\nDebug info:\\nstartPos:'+ startPos + " +
			"'\\nclipWidth:'+clipWidth+'\\nclipHeight:'+clipHeight+'\\ntileWidth:'+tileWidth+'\\ntileHeight:'+tileHeight + '\\nimageWidth:'+_image.width);" +
			"}"+
		"context.lineWidth = 1;" +
		"context.strokeRect(gutterWidth,gutterWidth,tileWidth-gutterWidth*2,tileHeight-gutterWidth*2);" +
		// now the margin
		"context.lineWidth = marginWidth;" +
		"context.strokeStyle = 'rgba(255,0,0,0.5)';"+
		"context.strokeRect(0,0,tileWidth,tileHeight);" +
		
		"}" +
		
		"</script>";
		
		return out;
	}
	
};//Class End