// this class represents a print element instanc in the layout

BinTabManager = function(uiLayout) 
{
  this.ctor(uiLayout);
};

BinTabManager.prototype = {

  ctor: function(uiLayout) 
  {
	this.uiLayout = uiLayout;
	this.tabs = null;
	this.selectedTabIdx = 0;
	
  },
  	//-------------------------------
  Initialize:function()
  {
	  // initialize with activate handler
	  this.tabs =  $("#ist_bin-tabs").tabs({
		  activate : function(event, ui)
		  {
		  		g_UILayout.binTabManager.OnTabChange(ui.newTab);					
		  }});	  
  },
  
	OnTabChange:function (tab) 
	{		
		this.selectedTabIdx = tab.index();
		this.uiLayout.DrawLayoutSection();	
		this.uiLayout.layoutWindow.scrollTop(0);
	},
	//------------------
	AddTabs:function(tabCount)
	{
		// this adds ids to the <li> toc element so it can be found on remove
		for(var i =1 ; i <= tabCount;++i)
		{		
			var strLi = "<li id=\"ist_bintoc-" +(i+1) + "\"><a id=\"ist_hreftoc-"+ +(i+1) + "\" href=\"#ist_bintab-1\">" + "Bin "+ (i+1)  + "</a> </li>";
			var li= $(strLi);
			this.tabs.find( ".ui-tabs-nav" ).append( li );		
		}		
		this.tabs.tabs( "refresh" );
	},
	//----------------------------
	// removes all tabs but the first one
	ResetTabs:function()
	{
		// use bins as a counter of how many tabs we got.
		// from jquery's standpoint we only have 1 tab but multiple  TOC items pointing to it
		// the number of bins should match the number of TOC items
		for(var i = this.uiLayout.printJob.bins.length; i >1; --i )
		{
			// remove the li element by id
			$('#ist_bintoc-'+i).remove();			
		}
		this.tabs.tabs( "refresh" );
	},	
	// update descriptive info that we display in the tab
	RefreshTabInfo:function()
	{
		
		for(var i = 0; i <this.uiLayout.printJob.bins.length;++i)
		{
			// rely on the fact that each new href has an id "ui-id-n"
			
			var href=$('#ist_hreftoc-'+(i+1));
			var text = href.text();
			
			text = /*"Bin "+ (i+1) + */this.uiLayout.printJob.GetBinDesc(i);
			href.text(text);
			
			var curToc = $('#ist_bintoc-'+(i+1));
			var html = curToc.html();
			
			//var text = curToc.html();
			// must be  a better way
			/*var pos = text.indexOf("<");
			if(pos > -1)
			{
				
			}
			text.replace("Bin"Bin "+ (i+1) + this.uiLayout.printJob.GetBinDesc(i);*/
			//curToc.html(text);
			//curToc.html("Bin "+ (i+1) + this.uiLayout.printJob.GetBinDesc(i));
		}
		this.tabs.tabs( "refresh" );
	}
	
  
};//Class End