// this class represents a bin in which items are placed
var STATE_ROTATE_UNFIT=0;
var STATE_ROTATE_ALL = 1;
var STATE_ROTATE_UNFIT2 = 2;
var STATE_ROTATE_END = 3;
var STATE_ROTATE_LAST= 4;
var STATE_ROTATE_SMALL=5; // rotate the smaller blocks leaving the larger ones unrotated

Bin = function(uiLayout,id) 
{
  this.ctor(uiLayout,id);
};

Bin.prototype = {

  ctor: function(uiLayout,id) 
  {
    this.uiLayout = uiLayout;
    this.id =id; 
    this.packer = null;
    this.unfitBlocks = null;      
    this.numDuplicates = 0;
	this.dupRangeStart = 0; 
	this.isDuplicate = false;
	this.name = "";
   
  },
  Pack:function(blocks,packMethod)
  {
	  this.Init();	 
      var i;
     
	  for(i = 0 ; i < blocks.length;++i)
      {
		 var curBlock = blocks[i];
		 var node = this.packer.Insert(curBlock.width, curBlock.height,packMethod);
		 // continue going
		 if(node.height == 0)
		 {
			this.AddToUnfitList(curBlock);
		 }
		 else
	     {
		  
			 // otherwise we fit it
			 //offset the x and y by the margin
			  curBlock.left = node.x + this.uiLayout.marginPx + "px";
	   		  curBlock.top =  node.y + this.uiLayout.marginPx + "px";
	   		 // the block may have been rotated, so copy the dimensions
	   		  curBlock.UpdateDimensionsAfterPack(node);	   		 	   		 
	   		 // curBlock.width = node.width;
	   		 // curBlock.height = node.height;
	   		  curBlock.binId = this.id;
	   		  node.elementInstance = curBlock; // link up with the element instance this node represents
   		 
	   		  // TODO: save some stats about how many items there are in the bin, maybe their area, etc
	   		  //delete curBlock.prepared; // block fit -delete prepared flag	so it doesnbt try to prepare it again in this run	 
	     }
      }	 
	  return this.unfitBlocks;	   
  },
  
  
//------------------------------

//---------------------------------
// this just flips blocks dimensions
FlipBlockDimensions:function(block)
{
	  var savedW = block.w;
	  var savedH = block.h;
	  block.w = savedH;
	  block.h = savedW;	  
	  block.dimensionsFlipped=true;
},
//------------------------
/*
* prepare the packer object
*/
InitPacker:function(width,height, margin)
{
  // var w = (this.uiLayout.calcTiles ? (width + (margin * 2)) : (width -(margin*2)));
  // var h = (this.uiLayout.calcTiles ? (height + (margin * 2)) : (height -(margin*2)));

   var h = height;
   var w = width;
   
   if(!this.uiLayout.calcTiles )
   {
	   // margin  reduces the printable area of the media
	   w -= (margin*2);
	   h -= (margin*2);
   }
   // with tiles we are packing tiles inside the image, not the media so margins are not taken into account
   
   if(this.packer == null)
   {
	   this.packer = new MaxRectsBinPack(w,h);
   }
   else
   {
	   this.packer.Init(w,h); 
   }
},
//draw the bin div
Draw:function(parentElementId)
{
		
		// set up the bin id
		var output =  "<div class=\"ist_binrect\" id=\"bin-" + this.id.toString() + "\" style=\"width:";
		output+=this.uiLayout.displayWidth() + "px;";
		
		output += "px;height:";
		var winDisplayHeight = this.uiLayout.displayHeight();
		var binHeight = (this.uiLayout.binHeightPx > winDisplayHeight ? winDisplayHeight : this.uiLayout.binHeightPx);
		
		output+= binHeight+ "px;";
		/*if(this.uiLayout.calcTiles)
		{
			// draw the background image of the first element
			output += "background-image: url(" + this.uiLayout.printJob.elements[0]. previewFile + "); height:" + binHeight + "px;width:"+this.uiLayout.displayWidth()+"px;";
		}*/
		output+= "\">";	
		output += "<\/div>";
		// append to the parent element
		$(parentElementId).append( output );	
},

SortByMax : function (a,b) 
{ 
	var ret = Math.max(b.w, b.h) - Math.max(a.w, a.h);
	return ret;
},

SortByMin : function (a,b) 
{ 
	var ret = Math.min(b.w, b.h) - Math.min(a.w, a.h); 
	return ret ;
},

SortByWidth : function (a,b) 
{ 
	return b.w - a.w; 
},

SortByHeight : function (a,b) 
{ 
	return b.h - a.h; 
},
AddToUnfitList:function( theBlock)
{
	//var needToAdd = true;
	if(this.unfitBlocks == null)
	{
		this.unfitBlocks = new Array();
	}
	/*for(var i =0; i < this.unfitBlocks.length; ++i)
	{
		var curBlock = this.unfitBlocks[i];
		if(curBlock.width == theBlock.width && curBlock.height == theBlock.height)
		{
			needToAdd = false;
			break;
		}		
	}
	/if(needToAdd)*/
	
	{
		this.unfitBlocks.push(theBlock);
	}
},
// Reset to known state
Init:function()
{
	// clean up unfit blocks before beginning
	if(this.unfitBlocks!=null)
	{
		this.unfitBlocks.length = null;
		this.unfitBlocks = null;
	}
	// used to prune duplicates
	this.numDuplicates = 0;
	this.dupRangeStart = 0; 
	this.isDuplicate = false;
	
	this.InitPacker(this.uiLayout.binWidthPx,this.uiLayout.binHeightPx,this.uiLayout.marginPx);
},
GetOccupancy:function()
{
	return (this.packer == null ? 0 : this.packer.Occupancy());
},
GetWaste:function()
{
	return (this.packer == null ? 0 : (100.00 - (this.packer.Occupancy() * 100)));
},
// determine if bin is identical to the one passed in 
IsIdenticalBin:function(inBin)
{
	// after bin is packed it should have a packer object that contains a list of used rects
	// easy cases
	//
	if((this.packer == null || inBin.packer == null) || 
		((this.packer.Occupancy() != inBin.packer.Occupancy()) || 
		 (this.packer.usedRectangles.length !=inBin.packer.usedRectangles.length)))
	{
		return false;
	}
	// there is the same number of rects in both bins and the occupancy rate is the same.
	// check if the rects in  bins are all the same width and height.
	for(var i =0; i < this.packer.usedRectangles.length; ++i)
	{
		var myRect=this.packer.usedRectangles[i];
		var otherRect = inBin.packer.usedRectangles[i];
		if(!myRect.EqualRect(otherRect))
		{
			return false;
		}
	}
	return true; 
},
//--Return the descriptive  info that we display in the bin tab
// If this bin represents more than one identical bin - show that in the tab
// Also show the percentage of occupancy in the bin
GetDesc:function()
{
	var ret ="";
	var strBinNumber; // we either display a bin number based on its id
	// if bin has a name - display it, ot
	if(this.name!= "")
	{
		ret = this.name;
	}
	else
	{		
	
		strBinNumber= ( this.id +1);	
	    if(this.numDuplicates > 0)
	    {
	    	strBinNumber += "(" + (this.numDuplicates+1) + "X)";
	    }
	    var strMedia = this.uiLayout.mediaType == MEDIA_TYPE_BIN ? "Board ": "Roll ";
	    ret= strMedia + (strBinNumber);	
	    // display the waste % - maybe should be in sq inches?
	    // for tiles this does not make sense
		if(this.packer!=null && !this.uiLayout.calcTiles)
		{
			var num = 100.00 - (this.packer.Occupancy() * 100);
			ret+=" : "+ num.toFixed(2) + "%";
		}
	}
	return ret;	
},
// the bin ids  map directly to tab ids so they need to be updated after the duplicate bins have been removed
UpdateBinId:function(newId)
{
	this.id = newId;
	if(this.packer!=null)
	{
		for(var i = 0; i< this.packer.usedRectangles.length; ++i )
		{
			var curRect = this.packer.usedRectangles[i];
			if(curRect.elementInstance!= null)
			{
				curRect.elementInstance.binId = newId;
			}
			                                         
		}
	}	
},


//---

};